% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{write.fst}
\alias{read.fst}
\alias{write.fst}
\title{Read and write fst files.}
\usage{
write.fst(x, path, compress = 0)

read.fst(path, columns = NULL, from = 1, to = NULL,
  as.data.table = FALSE)
}
\arguments{
\item{x}{A data frame to write to disk}

\item{path}{Path to fst file}

\item{compress}{Value in the range 0 to 100, indicating the amount of compression to use.}

\item{columns}{Column names to read. The default is to read all all columns.}

\item{from}{Read data starting from this row number.}

\item{to}{Read data up until this row number. The default is to read to the last row of the stored dataset.}

\item{as.data.table}{If TRUE, the result will be returned as a \code{data.table} object. Any keys set on
dataset \code{x} before writing, will be retained. This allows for storage of sorted datasets.}
}
\value{
Both functions return a data frame. \code{write.fst}
  invisibly returns \code{x} (so you can use this function in a pipeline).
}
\description{
Read and write data frames from and to a fast-storage (fst) file.
Allows for compression and (file level) random access of stored data, even for compressed datasets.
When using a \code{data.table} object for \code{x}, the key (if any) is preserved, allowing storage of sorted data.
}
\examples{
# Sample dataset
x <- data.frame(A = 1:10000, B = sample(c(TRUE, FALSE, NA), 10000, replace = TRUE))

# Uncompressed
write.fst(x, "dataset.fst")  # filesize: 41 KB
y <- read.fst("dataset.fst") # read uncompressed data

# Compressed
write.fst(x, "dataset.fst", 100)  # fileSize: 4 KB
y <- read.fst("dataset.fst") # read compressed data

# Random access
y <- read.fst("dataset.fst", "B") # read selection of columns
y <- read.fst("dataset.fst", "A", 100, 200) # read selection of columns and rows
}

