% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriNucIndex.R
\name{TriNucIndex}
\alias{TriNucIndex}
\title{Tri Nucleotide Index (TriNucIndex)}
\usage{
TriNucIndex(
  seqs,
  selectedNucIdx = 1:12,
  standardized = TRUE,
  threshold = 0.8,
  label = c(),
  outFormat = "mat",
  outputFileDist = ""
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{selectedNucIdx}{TriNucIndex function works based on physicochemical properties. Users, select the properties by their ids
or indexes in trinucleotide file.}

\item{standardized}{is a logical parameter. If it is set to TRUE, all the indices will be in their standard format.
The default value is TRUE.}

\item{threshold}{is a number between 0 to 1. In selectedNucIdx, indices with a correlation
higher than the threshold will be deleted. The default value is 0.8.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output depends on the outFormat parameter which can be either 'mat' or 'txt'. If outFormat is 'mat', the function returns a feature
matrix for sequences with the same length such that the number of columns is (sequence length)*(number of selected trinucleotide properties)
and the number of rows is equal to the number of sequences. It is usable for machine learning purposes.
If the outFormat is 'txt', the output is written to a tab-delimited file.
}
\description{
This function replaces trinucleotides in a sequence with their physicochemical properties in the trinucleotide index file.
}
\details{
There are 12 physicochemical indexes in the trinucleotide database.
}
\note{
This function is provided for sequences with the same lengths.
Users can use 'txt' option in outFormat parameter for sequences with different lengths.
Warning: If outFormat is set to 'mat' for sequences with different lengths, it returns an error.
Also, when output format is 'txt', label information is not shown in the text file.
It is noteworthy that 'txt' format is not usable for machine learning purposes.
}
\examples{

fileLNC<-system.file("extdata/Athaliana1.fa",package="ftrCOOL")
vect<-TriNucIndex(seqs = fileLNC, selectedNucIdx=1:5,threshold=1,outFormat="mat")
}
