% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CkSAApair.R
\name{CkSAApair}
\alias{CkSAApair}
\title{Composition of k-Spaced Amino Acids pairs (CkSAApair)}
\usage{
CkSAApair(seqs, rng = 3, upto = FALSE, normalized = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{rng}{This parameter can be a number or a vector. Each element of the vector shows the number of spaces between amino acid pairs.
For each k in the rng vector, a new vector (whose size is 400) is created which contains the frequency of pairs with k gaps.}

\item{upto}{It is a logical parameter. The default value is FALSE. If rng is a number and upto is set to TRUE, rng is converted
to a vector with values from [0 to rng].}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
The function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is 400*(length of rng vector).
}
\description{
This function calculates the composition of k-spaced amino acid pairs. In other words, it
computes the frequency of all amino acid pairs with k spaces.
}
\note{
'upto' is enabled only when rng is a number and not a vector.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat1<-CkSAApair(seqs=filePrs,rng=2,upto=TRUE,normalized=TRUE)

mat2<-CkSAApair(seqs=filePrs,rng=c(1,3,5))

}
