% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PseKRAAC_T15.R
\name{PseKRAAC_T15}
\alias{PseKRAAC_T15}
\title{Pseudo K_tuple Reduced Amino Acid Composition Type-15 (PseKRAAC_T15)}
\usage{
PseKRAAC_T15(
  seqs,
  type = "gap",
  Grp = 2,
  GapOrLambdaValue = 2,
  k = 4,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{type}{This parameter has two valid value "lambda" and "gap". "lambda"
calls lambda_model function and "gap" calls gap_model function.}

\item{Grp}{is a numeric value. It shows the id of an amino acid group.
Please find the available groups in the detail section.}

\item{GapOrLambdaValue}{is an integer.
If type is gap, this value shows number of gaps between two k-mers.
If type is lambda, the value of GapOrLambdaValue shows the number of gaps between each two amino acids of k-mers.}

\item{k}{This parameter keeps the value of k in k-mer.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is (Grp)^k.
}
\description{
There are 16 types of PseKRAAC function.
In the functions, a (user-selected) grouping of the amino acids might be used to reduce the amino acid alphabet.
Also, the functions have a type parameter.
The parameter determines the protein sequence analyses which can be either gap or lambda-correlation.
PseKRAAC_type15(PseKRAAC_T15) contains Grp 2-16,20.
}
\details{
Groups:

Grp2=c('MFILVAW', 'CYQHPGTSNRKDE'),
Grp3=c('MFILVAW', 'CYQHPGTSNRK', 'DE'),
Grp4=c('MFILV', 'ACW', 'YQHPGTSNRK', 'DE'),
Grp5=c('MFILV', 'ACW', 'YQHPGTSN', 'RK', 'DE'),
Grp6=c('MFILV', 'A', 'C', 'WYQHPGTSN', 'RK', 'DE'),
Grp7=c('MFILV', 'A', 'C', 'WYQHP', 'GTSN', 'RK', 'DE'),
Grp8=c('MFILV', 'A', 'C', 'WYQHP', 'G', 'TSN', 'RK', 'DE'),
Grp9=c('MF', 'ILV', 'A', 'C', 'WYQHP', 'G', 'TSN', 'RK', 'DE'),
Grp10=c('MF', 'ILV', 'A', 'C', 'WYQHP', 'G', 'TSN', 'RK', 'D', 'E'),
Grp11=c('MF', 'IL', 'V', 'A', 'C', 'WYQHP', 'G', 'TSN', 'RK', 'D', 'E'),
Grp12=c('MF', 'IL', 'V', 'A', 'C', 'WYQHP', 'G', 'TS', 'N', 'RK', 'D', 'E'),
Grp13=c('MF', 'IL', 'V', 'A', 'C', 'WYQHP', 'G', 'T', 'S', 'N', 'RK', 'D', 'E'),
Grp14=c('MF', 'I', 'L', 'V', 'A', 'C', 'WYQHP', 'G', 'T', 'S', 'N', 'RK', 'D', 'E'),
Grp15=c('MF', 'IL', 'V', 'A', 'C', 'WYQ', 'H', 'P', 'G', 'T', 'S', 'N', 'RK', 'D', 'E'),
Grp16=c('MF', 'I', 'L', 'V', 'A', 'C', 'WYQ', 'H', 'P', 'G', 'T', 'S', 'N', 'RK', 'D', 'E'),
Grp20=c('M', 'F', 'I', 'L', 'V', 'A', 'C', 'W', 'Y', 'Q', 'H', 'P', 'G', 'T', 'S', 'N', 'R', 'K', 'D', 'E')
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")

mat1<-PseKRAAC_T15(seqs=filePrs,type="gap",Grp=4,GapOrLambdaValue=3,k=2)

mat2<-PseKRAAC_T15(seqs=filePrs,type="lambda",Grp=4,GapOrLambdaValue=3,k=2)
}
\references{
Zuo, Yongchun, et al. "PseKRAAC: a flexible web server for generating pseudo K-tuple reduced amino acids composition." Bioinformatics 33.1 (2017): 122-124.
}
