% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PseKRAAC_T8.R
\name{PseKRAAC_T8}
\alias{PseKRAAC_T8}
\title{Pseudo K_tuple Reduced Amino Acid Composition Type-8 (PseKRAAC_T8)}
\usage{
PseKRAAC_T8(
  seqs,
  type = "gap",
  Grp = 5,
  GapOrLambdaValue = 2,
  k = 4,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{type}{This parameter has two valid value "lambda" and "gap". "lambda"
calls lambda_model function and "gap" calls gap_model function.}

\item{Grp}{is a numeric value. It shows the id of an amino acid group.
Please find the available groups in the detail section.}

\item{GapOrLambdaValue}{is an integer.
If type is gap, this value shows number of gaps between two k-mers.
If type is lambda, the value of GapOrLambdaValue shows the number of gaps between each two amino acids of k-mers.}

\item{k}{This parameter keeps the value of k in k-mer.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is (Grp)^k.
}
\description{
There are 16 types of PseKRAAC function.
In the functions, a (user-selected) grouping of the amino acids might be used to reduce the amino acid alphabet.
Also, the functions have a type parameter.
The parameter determines the protein sequence analyses which can be either gap or lambda-correlation.
PseKRAAC_type8(PseKRAAC_T8) contains Grp 2-20.
}
\details{
Groups:
Grp2=c('ADEGKNPQRST', 'CFHILMVWY'),
Grp3=c('ADEGNPST', 'CHKQRW', 'FILMVY'),
Grp4=c('AGNPST', 'CHWY', 'DEKQR', 'FILMV'),
Grp5=c('AGPST', 'CFWY', 'DEN', 'HKQR', 'ILMV'),
Grp6=c('APST', 'CW', 'DEGN', 'FHY', 'ILMV', 'KQR'),
Grp7=c('AGST', 'CW', 'DEN', 'FY', 'HP', 'ILMV', 'KQR'),
Grp8=c('AST', 'CG', 'DEN', 'FY', 'HP', 'ILV', 'KQR', 'MW'),
Grp9=c('AST', 'CW', 'DE', 'FY', 'GN', 'HQ', 'ILV', 'KR', 'MP'),
Grp10=c('AST', 'CW', 'DE', 'FY', 'GN', 'HQ', 'IV', 'KR', 'LM', 'P'),
Grp11=c('AST', 'C', 'DE', 'FY', 'GN', 'HQ', 'IV', 'KR', 'LM', 'P', 'W'),
Grp12=c('AST', 'C', 'DE', 'FY', 'G', 'HQ', 'IV', 'KR', 'LM', 'N', 'P', 'W'),
Grp13=c('AST', 'C', 'DE', 'FY', 'G', 'H', 'IV', 'KR', 'LM', 'N', 'P', 'Q', 'W'),
Grp14=c('AST', 'C', 'DE', 'FL', 'G', 'H', 'IV', 'KR', 'M', 'N', 'P', 'Q', 'W', 'Y'),
Grp15=c('AST', 'C', 'DE', 'F', 'G', 'H', 'IV', 'KR', 'L', 'M', 'N', 'P', 'Q', 'W', 'Y'),
Grp16=c('AT', 'C', 'DE', 'F', 'G', 'H', 'IV', 'KR', 'L', 'M', 'N', 'P', 'Q', 'S', 'W', 'Y'),
Grp17=c('AT', 'C', 'DE', 'F', 'G', 'H', 'IV', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'W', 'Y'),
Grp18=c('A', 'C', 'DE', 'F', 'G', 'H', 'IV', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'W', 'Y'),
Grp19=c('A', 'C', 'D', 'E', 'F', 'G', 'H', 'IV', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'W', 'Y'),
Grp20=c('A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'V', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'W', 'Y')
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")

mat1<-PseKRAAC_T8(seqs=filePrs,type="gap",Grp=4,GapOrLambdaValue=3,k=2)

mat2<-PseKRAAC_T8(seqs=filePrs,type="lambda",Grp=4,GapOrLambdaValue=3,k=2)
}
\references{
Zuo, Yongchun, et al. "PseKRAAC: a flexible web server for generating pseudo K-tuple reduced amino acids composition." Bioinformatics 33.1 (2017): 122-124.
}
