% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{ft_collect}
\alias{ft_collect}
\alias{ft_text}
\alias{ft_text.default}
\alias{ft_text.ft_data}
\title{Collect article text from local files}
\usage{
ft_collect(x, ...)

ft_text(x, ...)

\method{ft_text}{default}(x, ...)

\method{ft_text}{ft_data}(x, ...)
}
\arguments{
\item{x}{Input. An object of class \code{ft_data}}

\item{...}{Further args, ignored.}
}
\value{
an object of class \code{ft_data}, but the \code{data} slot should have
character string of text from the XML/plain text/PDF file
}
\description{
\code{ft_collect} grabs full text data from file paths in your
\code{ft_data} object (result of call to \code{ft_get()}). \code{ft_text} is a
convenience function to grab the nested text data and bring it up in
the list for easier access
}
\details{
The result of this call is actual text you can read
}
\examples{
\dontrun{
# Get some data
x <- ft_get('10.1371/journal.pone.0086169', from='plos')

# note that the data is not in the object, gives NULL
x$plos$data$data

# Collect data from the .xml file
y <- x \%>\% ft_collect()

# note how the data is now in the object
y$plos$data$data

# Let's get the actual 
## ft_collect() alone, replaces file pointers with parsed text, 
##  maintaining object structure
x \%>\% ft_collect() 
## pulls the text out of the object
x \%>\% ft_collect() \%>\% ft_text()
}
}
