% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataClass.R, R/funDataMethods.R, R/names.R,
%   R/str.R, R/summary.R
\docType{class}
\name{funData-class}
\alias{funData-class}
\alias{funData}
\alias{funData,list,array-method}
\alias{funData,numeric,array-method}
\alias{show,funData-method}
\alias{names,funData-method}
\alias{names<-,funData-method}
\alias{str,funData-method}
\alias{summary,funData-method}
\title{A class for (univariate) functional data}
\usage{
\S4method{funData}{list,array}(argvals, X)

\S4method{funData}{numeric,array}(argvals, X)

\S4method{show}{funData}(object)

\S4method{names}{funData}(x)

\S4method{names}{funData}(x) <- value

\S4method{str}{funData}(object, ...)

\S4method{summary}{funData}(object, ...)
}
\arguments{
\item{argvals}{A list of numeric vectors or a single numeric vector, giving the 
sampling points in the domains. See Details.}

\item{X}{An array of dimension  \eqn{N \times M}{N x M} (for one-dimensional
domains, or \eqn{N \times M_1 \times \ldots \times M_d}{N x M_1 x \ldots x
M_d} for higher-dimensional domains), giving the observed values for
\eqn{N}{N} individuals. Missing values can be included via \code{NA}. See
Details.}

\item{object}{A \code{funData} object.}

\item{x}{The \code{funData} object.}

\item{value}{The names to be given to the \code{funData} curves.}

\item{...}{Other parameters passed to \code{summary}.}
}
\description{
The \code{funData} class represents functional data on \eqn{d}{d}-dimensional
domains. The two slots represent the domain (x-values) and the values of the 
different observations (y-values).
}
\details{
Functional data can be seen as realizations of a random process \deqn{X: 
\mathcal{T} \to \mathrm{IR}}{X: T -> IR} on a \eqn{d}{d}-dimensional 
domain \eqn{\mathcal{T}}{T}. The data is usually sampled on a fine grid 
\eqn{T \subset \mathcal{T}}{T subset of T}, which is represented in the 
\code{argvals} slot of a \code{funData} object. All observations are assumed 
to be sampled over the same grid \eqn{T}{T}, but can contain missing values 
(see below). If \eqn{\mathcal{T}}{T} is one-dimensional, \code{argvals} 
can be supplied either as a numeric vector, containing the x-values or as a 
list, containing such a vector. If \eqn{\mathcal{T}}{T} is 
higher-dimensional, \code{argvals} must always be supplied as a list, 
containing numeric vectors of the x-values in dimensions 
\eqn{1,\ldots,d}{1,\ldots,d}.

The observed values are represented in the \code{X} slot of a \code{funData} 
object, which is an array of dimension  \eqn{N \times M}{N x M} (for 
one-dimensional domains, or \eqn{N \times M_1 \times \ldots \times M_d}{N x 
M_1 x \ldots x M_d} for higher-dimensional domains). Here \eqn{N}{N} equals 
the number of observations and \eqn{M}{M} denotes the number of sampling 
points (for higher dimensional domains \eqn{M_i}{M_i} denotes the number of
sampling points in dimension \eqn{i, i = 1,\ldots, d}{i, i = 1,\ldots, d}).
Missing values in the observations are allowed and must be marked by
\code{NA}. If missing values occur due to irregular observation points, the
data can be stored alternatively as an object of class
\code{\linkS4class{irregFunData}}.

Generic functions for the \code{funData} class include a print method, 
\link[=plot.funData]{plotting} and \link[=Arith.funData]{basic arithmetics}. 
Further methods for \code{funData}: \itemize{ \item \code{\link{dimSupp}}, 
\code{\link{nObs}}: Informations about the support dimensions and the number 
of observations, \item \code{\link{getArgvals}}, \code{\link{extractObs}}: 
Getting/Setting slot values (instead of accessing them directly via 
\code{funData@argvals, funData@X}) and extracting single observations or 
data on a subset of the domain, \item \code{\link{integrate}}, 
\code{\link{norm}}: Integrate all observations over their domain or 
calculating the \eqn{L^2}{L^2} norm.}

A \code{funData} object can be coerced to a \code{multiFunData} object using 
\code{as.multiFunData(funDataObject).}
}
\section{Methods (by generic)}{
\itemize{
\item \code{funData}: Constructor for functional data objects with \code{argvals} given as list.

\item \code{funData}: Constructor for functional data objects with \code{argvals}
given as vector of numerics (only valid for one-dimensional domains).

\item \code{show}: Print basic information about the \code{funData} object
in the console. The default console output for \code{funData} objects.

\item \code{names}: Get the names of the \code{funData} object.

\item \code{names<-}: Set the names of the \code{funData} object.

\item \code{str}: A \code{str} method for \code{funData} objects, giving a compact overview of the structure.

\item \code{summary}: A \code{summary} method for \code{funData} objects.
}}

\section{Slots}{

\describe{
\item{\code{argvals}}{The domain \eqn{\mathcal{T}}{T} of the data. See Details.}

\item{\code{X}}{The functional data samples. See Details.}
}}

\examples{
### Creating a one-dimensional funData object with 2 observations
# Basic
f1 <- new("funData", argvals = list(1:5), X = rbind(1:5,6:10))
# Using the constructor with first argument supplied as array
f2 <- funData(argvals = list(1:5), X = rbind(1:5, 6:10)) 
# Using the constructor with first argument supplied as numeric vector
f3 <- funData(argvals = 1:5, X = rbind(1:5, 6:10)) 
# Test if all the same
all.equal(f1,f2) 
all.equal(f1,f3)
# Display funData object in the console
f3 

# A more realistic object
argvals <- seq(0,2*pi,0.01)
object <- funData(argvals, outer(seq(0.75, 1.25, by = 0.05), sin(argvals)))
# Display / summary give basic information
object 
summary(object)
# Use the plot function to get an impression of the data
plot(object) 


### Higher-dimensional funData objects with 2 observations
# Basic
g1 <- new("funData", argvals = list(1:5, 1:3),
                     X = array(1:30, dim = c(2,5,3))) 
# Using the constructor
g2 <- funData(argvals = list(1:5, 1:3),
              X = array(1:30, dim = c(2,5,3)))
# Test if the same
all.equal(g1,g2)
# Display funData object in the console
g2 
# Summarize information
summary(g2)
}
\seealso{
\code{\linkS4class{irregFunData}}, \code{\linkS4class{multiFunData}}
}
