% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicting.R
\name{predict_performance}
\alias{predict_performance}
\title{Predicting performances of assemblages
by only knowing their elemental composition}
\usage{
predict_performance(appFct, appMotifs, appOccur,
            supMotifs, supOccur,
            opt.mean = "amean",
            opt.model  = "bymot"  )
}
\arguments{
\item{appFct}{a vector of numeric values (assembly properties).}

\item{appMotifs}{a vector of labels of \code{length(fct)} (assembly motifs).}

\item{appOccur}{a matrix of occurrence (occurrence of components).
Its first dimension equals to \code{length(fct)}. Its second dimension
 equals to the number of components.}

\item{supMotifs}{a vector of labels of \code{length(fct)} (assembly motifs).}

\item{supOccur}{a matrix of occurrence (occurrence of components).
Its first dimension equals to \code{length(fct)}. Its second dimension
 equals to the number of components.}

\item{opt.mean}{equal to \code{"amean"} (by default) or \code{"gmean"}.}

\item{opt.model}{equal to \code{"bymot"} (by default) or \code{"byelt"}.}
}
\value{
Return the arithmetic mean of a vector, as standard \code{mean}
 function.
}
\description{
Takes a vector \code{fct} of assembly performances
over several experiments
and returns a vector of performances
predicted as the mean performances of assemblages
that share the same assembly motif. \cr

Assembly motifs are labelled in the vector \code{assMotif}.
Experiments are labelled in the vector \code{xpr}.
Modelling options are indicated in \code{opt.mean} and \code{opt.model}.
Occurrence matrix \code{mOccur} is used if \code{opt.model =  "byelt"}.
Cross-validation is leave-one-out or jackknifesi
}
\details{
Prediction is computed using arithmetic mean \code{amean} by motif
\code{bymot} in a whole (WITHOUT taking into account species contribution).
The components belonging to a same motif are divided into \code{jack[2]}
subsets of \code{jack[1]} components. Prediction is computed by excluding
\code{jack[1]} components, of which the component to predict. If the total
number of components belonging to the motif is lower than
\code{jack[1]*jack[2]}, prediction is computed by Leave-One-Out (LOO).
}
\seealso{
\code{\link{calibrate_byminrss}} \cr
\code{\link{validate_using_cross_validation}}
}
\keyword{internal}
