#' Predicate function operator that creates new predicate functions linked by the || operator.
#'
#' @param ... n functions to apply in order from left to right
#' @return a function
#' @family predicate function operators
#' @seealso \code{\link{Andify}} to create new predicate functions linked by the && operator.
#' @examples
#' # Examples
#' is_character_or_factor <- Orify(is.character, is.factor)
#' is_character_or_factor(letters)
#' is_character_or_factor(factor(state.abb))
#' is_character_or_factor(1:100)
#' @export
Orify <- function(...) {
  fs <- lapply(list(...), match.fun)
  first <- fs[[1]]
  rest <- fs[-1]

  function(...) {
    out <- first(...)
    for (f in rest) {
      if (out) return(TRUE)
      out <- `||`(out, f(...))
    }
    out
  }
}





