% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{str_detect_r_docs}
\alias{str_detect_r_docs}
\title{String Detect R or Rmarkdown or Quarto File endings}
\usage{
str_detect_r_docs(
  contents,
  pattern = stringr::regex("(r|rmd|rmarkdown|qmd)$", ignore_case = TRUE),
  rmv_index = TRUE
)
}
\arguments{
\item{contents}{Character vector of file path.}

\item{pattern}{Regex pattern to identify file types.}

\item{rmv_index}{Logical, default to \code{TRUE}, most repos containing blogdown
sites will have an index.R file at the root. Change to \code{FALSE} if you don't
want this file removed.}
}
\value{
Logical vector.
}
\description{
Wrapper on \code{stringr::str_detect()} to return \code{TRUE} for only R and Rmarkdown
or Quarto files, else \code{FALSE}.
}
\examples{
files <- c("file1.R", "file2.Rmd", "file3.Rmarkdown", "file4.Rproj", "file5.qmd")
funspotr::str_detect_r_docs(files)
}
\keyword{internal}
