% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainMetaLayer.R
\name{TrainMetaLayer}
\alias{TrainMetaLayer}
\title{TrainMetaLayer Class}
\description{
This class implement a meta meta layer. A \link{TrainMetaLayer} can only exist as unique element of a \link{Training} object.

A layer is structured as followed:
\itemize{
\item \link{Lrner}: It is set by the user to be trained on the meta training data.
\item \link{TrainData}: It are modality-specific prediction data, automatically created by the internal cross validation.
\item \link{Model}: The meta model, result of training the learner on the training data, and therefore, not to be set by the user.
\item \link{TestData}: The meta new data to be predicted, consisting in predictions obtained from each layer.
}

A meta layer can train its meta learner on the meta training data and store the resulting meta model.
The meta layer can predict values given a new meta layer.
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{TrainMetaLayer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TrainMetaLayer-new}{\code{TrainMetaLayer$new()}}
\item \href{#method-TrainMetaLayer-print}{\code{TrainMetaLayer$print()}}
\item \href{#method-TrainMetaLayer-getTraining}{\code{TrainMetaLayer$getTraining()}}
\item \href{#method-TrainMetaLayer-getTargetObj}{\code{TrainMetaLayer$getTargetObj()}}
\item \href{#method-TrainMetaLayer-train}{\code{TrainMetaLayer$train()}}
\item \href{#method-TrainMetaLayer-predict}{\code{TrainMetaLayer$predict()}}
\item \href{#method-TrainMetaLayer-impute}{\code{TrainMetaLayer$impute()}}
\item \href{#method-TrainMetaLayer-getTrainData}{\code{TrainMetaLayer$getTrainData()}}
\item \href{#method-TrainMetaLayer-getLrner}{\code{TrainMetaLayer$getLrner()}}
\item \href{#method-TrainMetaLayer-getModel}{\code{TrainMetaLayer$getModel()}}
\item \href{#method-TrainMetaLayer-openAccess}{\code{TrainMetaLayer$openAccess()}}
\item \href{#method-TrainMetaLayer-closeAccess}{\code{TrainMetaLayer$closeAccess()}}
\item \href{#method-TrainMetaLayer-getAccess}{\code{TrainMetaLayer$getAccess()}}
\item \href{#method-TrainMetaLayer-setTrainData}{\code{TrainMetaLayer$setTrainData()}}
\item \href{#method-TrainMetaLayer-checkLrnerExist}{\code{TrainMetaLayer$checkLrnerExist()}}
\item \href{#method-TrainMetaLayer-checkModelExist}{\code{TrainMetaLayer$checkModelExist()}}
\item \href{#method-TrainMetaLayer-checkTrainDataExist}{\code{TrainMetaLayer$checkTrainDataExist()}}
\item \href{#method-TrainMetaLayer-set2NotTrained}{\code{TrainMetaLayer$set2NotTrained()}}
\item \href{#method-TrainMetaLayer-summary}{\code{TrainMetaLayer$summary()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-new"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$new(id, training)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character}\cr
Id of training meta-layer.}

\item{\code{training}}{\code{Training}\cr}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-print"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-getTraining"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-getTraining}{}}}
\subsection{Method \code{getTraining()}}{
Getter of the current training object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$getTraining()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current training object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-getTargetObj"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-getTargetObj}{}}}
\subsection{Method \code{getTargetObj()}}{
Getter of the target object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$getTargetObj()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-train"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-train}{}}}
\subsection{Method \code{train()}}{
Trains the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$train(ind_subset = NULL, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{vector} \cr
ID subset of individuals to be used for training.}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current layer is returned with the resulting model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-predict"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-predict}{}}}
\subsection{Method \code{predict()}}{
Predicts values for the new layer taking as argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$predict(new_layer, ind_subset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_layer}}{\code{TrainLayer} \cr
A trained TrainLayer object.}

\item{\code{ind_subset}}{\code{vector} \cr
Index subset.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new object with the predicted values is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-impute"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-impute}{}}}
\subsection{Method \code{impute()}}{
Imputes missing values in modality-specific predictions.
Only mode and median based imputations are actually supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$impute(impute_fct = NULL, impute_param = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{impute_fct}}{\code{character} \cr
An imputation function to use instead of median or mode imputation.
This parameter is actually not used.
This corresponds to median or mode based imputation.}

\item{\code{impute_param}}{\code{list} \cr
The list of parameters to call the imputation function. Not yet implemented!}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new object with the predicted values is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-getTrainData"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-getTrainData}{}}}
\subsection{Method \code{getTrainData()}}{
Getter of the training dataset stored on the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$getTrainData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{TrainData} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-getLrner"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-getLrner}{}}}
\subsection{Method \code{getLrner()}}{
Getter of the learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$getLrner()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{Lrner} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-getModel"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-getModel}{}}}
\subsection{Method \code{getModel()}}{
Getter of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$getModel()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{Model} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-openAccess"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-openAccess}{}}}
\subsection{Method \code{openAccess()}}{
Open access to the meta layer. A meta learner is only
modifiable if the access is opened.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$openAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-closeAccess"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-closeAccess}{}}}
\subsection{Method \code{closeAccess()}}{
Close access to the meta layer to avoid accidental
modification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$closeAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-getAccess"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-getAccess}{}}}
\subsection{Method \code{getAccess()}}{
Getter of the current access to the meta layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$getAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-setTrainData"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-setTrainData}{}}}
\subsection{Method \code{setTrainData()}}{
Create and set an \link{TrainData} object to the current
meta learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$setTrainData(id, ind_col, data_frame)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
ID of the \link{TrainData} object to be instanciated.}

\item{\code{ind_col}}{\code{character} \cr
Name of individual column IDs.}

\item{\code{data_frame}}{\code{data.frame} \cr
\code{data.frame} of layer specific predictions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-checkLrnerExist"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-checkLrnerExist}{}}}
\subsection{Method \code{checkLrnerExist()}}{
Check whether a training data has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$checkLrnerExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-checkModelExist"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-checkModelExist}{}}}
\subsection{Method \code{checkModelExist()}}{
Check whether a model has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$checkModelExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-checkTrainDataExist"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-checkTrainDataExist}{}}}
\subsection{Method \code{checkTrainDataExist()}}{
Check whether a training data has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$checkTrainDataExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-set2NotTrained"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-set2NotTrained}{}}}
\subsection{Method \code{set2NotTrained()}}{
Only usefull to reset status FALSE after cross validation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$set2NotTrained()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainMetaLayer-summary"></a>}}
\if{latex}{\out{\hypertarget{method-TrainMetaLayer-summary}{}}}
\subsection{Method \code{summary()}}{
Generate summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainMetaLayer$summary()}\if{html}{\out{</div>}}
}

}
}
