% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{getGlobalsAndPackages}
\alias{getGlobalsAndPackages}
\title{Retrieves global variables of an expression and their associated packages}
\usage{
getGlobalsAndPackages(
  expr,
  envir = parent.frame(),
  tweak = tweakExpression,
  globals = TRUE,
  resolve = getOption("future.globals.resolve", FALSE),
  persistent = FALSE,
  maxSize = getOption("future.globals.maxSize", 500 * 1024^2),
  ...
)
}
\arguments{
\item{expr}{An \R expression whose globals should be found.}

\item{envir}{The environment from which globals should be searched.}

\item{tweak}{(optional) A function that takes an expression and returned a modified one.}

\item{globals}{(optional) a logical, a character vector, a named list, or a \link[globals]{Globals} object.  If TRUE, globals are identified by code inspection based on \code{expr} and \code{tweak} searching from environment \code{envir}.  If FALSE, no globals are used.  If a character vector, then globals are identified by lookup based their names \code{globals} searching from environment \code{envir}.  If a named list or a Globals object, the globals are used as is.}

\item{resolve}{If TRUE, any future that is a global variables (or part of one) is resolved and replaced by a "constant" future.
persistent If TRUE, non-existing globals (= identified in expression but not found in memory) are always silently ignored and assumed to be existing in the evaluation environment.  If FALSE, non-existing globals are by default ignored, but may also trigger an informative error if option \option{future.globals.onMissing} in \code{"error"}.}

\item{maxSize}{The maximum allowed total size (in bytes) of globals - for
the purpose of preventing too large exports / transfers happening by
mistake.  If the total size of the global objects are greater than this
limit, an informative error message is produced. If
\code{maxSize = +Inf}, then this assertion is skipped. (Default: 500 MiB).}

\item{\dots}{Not used.}
}
\value{
A named list with elements \code{expr} (the tweaked expression), \code{globals} (a named list) and \code{packages} (a character string).
}
\description{
Retrieves global variables of an expression and their associated packages
}
\seealso{
Internally, \code{\link[globals]{globalsOf}()} is used to identify globals and associated packages from the expression.
}
\keyword{internal}
