% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delayed_api-futureAssign.R,
%   R/infix_api-01-futureAssign_OP.R, R/infix_api-02-globals_OP.R,
%   R/infix_api-03-seed_OP.R, R/infix_api-04-stdout_OP.R,
%   R/infix_api-05-conditions_OP.R, R/infix_api-06-lazy_OP.R,
%   R/infix_api-07-label_OP.R, R/infix_api-08-plan_OP.R,
%   R/infix_api-09-tweak_OP.R
\name{futureAssign}
\alias{futureAssign}
\alias{\%<-\%}
\alias{\%->\%}
\alias{\%globals\%}
\alias{\%packages\%}
\alias{\%seed\%}
\alias{\%stdout\%}
\alias{\%conditions\%}
\alias{\%lazy\%}
\alias{\%label\%}
\alias{\%plan\%}
\alias{\%tweak\%}
\title{Create a future assignment}
\usage{
futureAssign(
  x,
  value,
  envir = parent.frame(),
  substitute = TRUE,
  lazy = FALSE,
  seed = FALSE,
  globals = TRUE,
  packages = NULL,
  stdout = TRUE,
  conditions = "condition",
  earlySignal = FALSE,
  label = NULL,
  gc = FALSE,
  ...,
  assign.env = envir
)

x \%<-\% value

fassignment \%globals\% globals
fassignment \%packages\% packages

fassignment \%seed\% seed

fassignment \%stdout\% capture

fassignment \%conditions\% capture

fassignment \%lazy\% lazy

fassignment \%label\% label

fassignment \%plan\% strategy

fassignment \%tweak\% tweaks
}
\arguments{
\item{x}{the name of a future variable, which will hold the value
of the future expression (as a promise).}

\item{value}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{seed}{(optional) If TRUE, the random seed, that is, the state of the
random number generator (RNG) will be set such that statistically sound
random numbers are produced (also during parallelization).
If FALSE (default), it is assumed that the future expression does neither
need nor use random numbers generation.
To use a fixed random seed, specify a L'Ecuyer-CMRG seed (seven integer)
or a regular RNG seed (a single integer).  If the latter, then a
L'Ecuyer-CMRG seed will be automatically created based on the given seed.
Furthermore, if FALSE, then the future will be monitored to make sure it
does not use random numbers.  If it does and depending on the value of
option \link{future.rng.onMisuse}, the check is
ignored, an informative warning, or error will be produced.
If \code{seed} is NULL, then the effect is as with \code{seed = FALSE}
but without the RNG check being performed.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[=future]{future()}}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{stdout}{If TRUE (default), then the standard output is captured,
and re-outputted when \code{value()} is called.
If FALSE, any output is silenced (by sinking it to the null device as
it is outputted).
Using \code{stdout = structure(TRUE, drop = TRUE)} causes the captured
standard output to be dropped from the future object as soon as it has
been relayed. This can help decrease the overall memory consumed by
captured output across futures.
Using \code{stdout = NA} fully avoids intercepting the standard output;
behavior of such unhandled standard output depends on the future backend.}

\item{conditions}{A character string of conditions classes to be captured
and relayed.  The default is to relay all conditions, including messages
and warnings.  To drop all conditions, use \code{conditions = character(0)}.
Errors are always relayed.
Attribute \code{exclude} can be used to ignore specific classes, e.g.
\code{conditions = structure("condition", exclude = "message")} will capture
all \code{condition} classes except those that inherits from the \code{message} class.
Using \code{conditions = structure(..., drop = TRUE)} causes any captured
conditions to be dropped from the future object as soon as it has
been relayed, e.g. by \code{value(f)}. This can help decrease the overall
memory consumed by captured conditions across futures.
Using \code{conditions = NULL} (not recommended) avoids intercepting conditions,
except from errors; behavior of such unhandled conditions depends on the
future backend and the environment from which R runs.}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{label}{A character string label attached to the future.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{assign.env}{The \link[base]{environment} to which the variable
should be assigned.}

\item{fassignment}{The future assignment, e.g.
\code{x \%<-\% { expr }}.}

\item{capture}{If TRUE, the standard output will be captured, otherwise not.}

\item{strategy}{The backend controlling how the future is
resolved. See \code{\link[=plan]{plan()}} for further details.}

\item{tweaks}{A named list (or vector) with arguments that
should be changed relative to the current backend.}

\item{\ldots}{Additional arguments passed to \code{\link[=Future]{Future()}}.}
}
\value{
\code{futureAssign()} and \code{x \%<-\% expr} returns the \link{Future} invisibly,
e.g. \code{f <- futureAssign("x", expr)} and \code{f <- (x \%<-\% expr)}.
}
\description{
\code{x \%<-\% value} (also known as a "future assignment") and
\code{futureAssign("x", value)} create a \link{Future} that evaluates the expression
(\code{value}) and binds it to variable \code{x} (as a
\link[base:delayedAssign]{promise}). The expression is evaluated in parallel
in the background. Later on, when \code{x} is first queried, the value of future
is automatically retrieved as it were a regular variable and \code{x} is
materialized as a regular value.
}
\details{
For a future created via a future assignment, \code{x \%<-\% value} or
\code{futureAssign("x", value)}, the value is bound to a promise, which when
queried will internally call \code{\link[=value]{value()}}  on the future and which will then
be resolved into a regular variable bound to that value. For example, with
future assignment \code{x \%<-\% value}, the first time variable \code{x} is queried
the call blocks if, and only if, the future is not yet resolved. As soon
as it is resolved, and any succeeding queries, querying \code{x} will
immediately give the value.

The future assignment construct \code{x \%<-\% value} is not a formal assignment
per se, but a binary infix operator on objects \code{x} and expression \code{value}.
However, by using non-standard evaluation, this constructs can emulate an
assignment operator similar to \code{x <- value}. Due to \R's precedence rules
of operators, future expressions often need to be explicitly bracketed,
e.g. \code{x \%<-\% { a + b }}.
}
\section{Adjust future arguments of a future assignment}{


\code{\link[=future]{future()}} and \code{\link[=futureAssign]{futureAssign()}} take several arguments that can be used
to explicitly specify what global variables and packages the future should
use. They can also be used to override default behaviors of the future,
e.g. whether output should be relayed or not. When using a future
assignment, these arguments can be specified via corresponding
assignment expression.  For example, \code{x \%<-\% { rnorm(10) } \%seed\% TRUE}
corresponds to \code{futureAssign("x", { rnorm(10) }, seed = TRUE)}. Here are
a several examples.

To explicitly specify variables and functions that a future assignment
should use, use \verb{\%globals\%}. To explicitly specify which packages need
to be attached for the evaluate to success, use \verb{\%packages\%}. For
example,

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x <- rnorm(1000)
> y \%<-\% \{ median(x) \} \%globals\% list(x = x) \%packages\% "stats"
> y
[1] -0.03956372
}\if{html}{\out{</div>}}

The \code{median()} function is part of the 'stats' package.

To declare that you will generate random numbers, use \verb{\%seed\%}, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x \%<-\% \{ rnorm(3) \} \%seed\% TRUE
> x
[1] -0.2590562 -1.2262495  0.8858702
}\if{html}{\out{</div>}}

To disable relaying of standard output (e.g. \code{print()}, \code{cat()}, and
\code{str()}), while keeping relaying of conditions (e.g. \code{message()} and

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x \%<-\% \{ cat("Hello\\n"); message("Hi there"); 42 \} \%stdout\% FALSE
> y <- 13
> z <- x + y
Hi there
> z
[1] 55
}\if{html}{\out{</div>}}

To disable relaying of conditions, use \verb{\%conditions\%}, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x \%<-\% \{ cat("Hello\\n"); message("Hi there"); 42 \} \%conditions\% character(0)
> y <- 13
> z <- x + y
Hello
> z
[1] 55
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x \%<-\% \{ print(1:10); message("Hello"); 42 \} \%stdout\% FALSE
> y <- 13
> z <- x + y
Hello
> z
[1] 55
}\if{html}{\out{</div>}}

To create a future without launching in such that it will only be
processed if the value is really needed, use \verb{\%lazy\%}, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x \%<-\% \{ Sys.sleep(5); 42 \} \%lazy\% TRUE
> y <- sum(1:10)
> system.time(z <- x + y)
  user  system elapsed 
  0.004   0.000   5.008
> z
[1] 97
}\if{html}{\out{</div>}}
}

\section{Error handling}{


Because future assignments are promises, errors produced by the the
future expression will not be signaled until the value of the future is
requested. For example, if you create a future assignment that produce
an error, you will not be affected by the error until you "touch" the
future-assignment variable. For example,

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x \%<-\% \{ stop("boom") \}
> y <- sum(1:10)
> z <- x + y
Error in eval(quote(\{ : boom
}\if{html}{\out{</div>}}
}

\section{Use alternative future backend for future assignment}{


Futures are evaluated on the future backend that the user has specified
by \code{\link[=plan]{plan()}}. With regular futures, we can temporarily use another future
backend by wrapping our code in \verb{with(plan(...), \{ ... \}]}, or temporarily
inside a function using \code{with(plan(...), local = TRUE)}. To achieve the
same for a specific future assignment, use \verb{\%plan\%}, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{> plan(multisession)
> x \%<-\% \{ 42 \}
> y \%<-\% \{ 13 \} \%plan\% sequential
> z <- x + y
> z
[1] 55
}\if{html}{\out{</div>}}

Here \code{x} is resolved in the background via the \link{multisession} backend,
whereas \code{y} is resolved sequentially in the main R session.
}

\section{Getting the future object of a future assignment}{


The underlying \link{Future} of a future variable \code{x} can be retrieved without
blocking using \code{f <- \link{futureOf}(x)}, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{> x \%<-\% \{ stop("boom") \}
> f_x <- futureOf(x)
> resolved(f_x)
[1] TRUE
> x
Error in eval(quote(\{ : boom
> value(f_x)
Error in eval(quote(\{ : boom
}\if{html}{\out{</div>}}

Technically, both the future and the variable (promise) are assigned at
the same time to environment \code{assign.env} where the name of the future is
\verb{.future_<name>}.
}

