% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{buildStructureEnsembles}
\alias{buildStructureEnsembles}
\title{List files for a single ensemble member}
\usage{
buildStructureEnsembles(ensemblePath, coordinateFilenames, tasFilenames,
  timeFilenames, dataDirectories)
}
\arguments{
\item{ensemblePath}{A character string that gives the absolute file path
for files for an ensemble member within the user-specified projection
directory (\code{dataFolder}).}

\item{coordinateFilenames}{Character string the with filename of each
grid point location file. This filename should be identical for all
ensemble member subdirectories included in the \code{dataFolder} directory.
See the package vignette for an example of the required structure for this
file.}

\item{tasFilenames}{Character string the with filename of each climate
projection file. This filename should be identical for all ensemble
member subdirectories included in the \code{dataFolder} directory. See the
package vignette for an example of the required structure for this file.}

\item{timeFilenames}{Character string the with filename of each projection
dates file. This filename should be identical for all ensemble
member  subdirectories included in the \code{dataFolder} directory. See
the package vignette for an example of the required structure for this
file.}

\item{dataDirectories}{A list object, with two elements, one for each of the
two subdirectories included in the main directory. Typically, these will
be separate directories of historical and projection experiments from
climate models. Each element of the list should be named with the name of
the subdirectory and should provide a numeric vector with the starting and
ending years of the data within each of the two subdirectories (e.g.,
\code{list("historical" = c(1990, 1999), "rcp85" = c(2060, 2079))}
for a \code{dataFolder} with historical experiment data for 1990 to 1999
and RCP8.5 projections for 2060 to 2079).}
}
\value{
A list of length 2. The first element is the name of the ensemble
that was processed. The second element is a vector with the filepaths of
the three files.
}
\description{
This function reads through the user-specified \code{dataFolder} directory
and creates a list with pathnames to all three files (projection times, grid
points, and projections) for a single ensemble member.
}

