% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genome_join.R
\name{genome_join}
\alias{genome_join}
\alias{genome_inner_join}
\alias{genome_left_join}
\alias{genome_right_join}
\alias{genome_full_join}
\alias{genome_semi_join}
\alias{genome_anti_join}
\title{Join two tables based on overlapping genomic intervals: both a}
\usage{
genome_join(x, y, by = NULL, mode = "inner", ...)

genome_inner_join(x, y, by = NULL, ...)

genome_left_join(x, y, by = NULL, ...)

genome_right_join(x, y, by = NULL, ...)

genome_full_join(x, y, by = NULL, ...)

genome_semi_join(x, y, by = NULL, ...)

genome_anti_join(x, y, by = NULL, ...)
}
\arguments{
\item{x}{A tbl}

\item{y}{A tbl}

\item{by}{Names of columns to join on, in order c("chromosome", "start", "end").
A match will be counted only if the chromosomes are equal and the start/end pairs
overlap.}

\item{mode}{One of "inner", "left", "right", "full" "semi", or "anti"}

\item{...}{Extra arguments passed on to \code{\link[IRanges]{findOverlaps}}}
}
\description{
This is an extension of \code{\link{interval_join}} specific to genomic intervals.
Genomic intervals include both a chromosome ID and an interval: items are only
considered matching if the chromosome ID matches and the interval overlaps.
Note that there must be three arguments to by, and that they must be in the order
c("chromosome", "start", "end").
}
\details{
All the extra arguments to \code{\link{interval_join}}, which are
passed on to \code{\link[IRanges]{findOverlaps}}, work for \code{genome_join}
as well. These include \code{maxgap} and \code{minoverlap}.
}
\examples{

library(dplyr)

x1 <- data_frame(id1 = 1:4,
                 chromosome = c("chr1", "chr1", "chr2", "chr2"),
                 start = c(100, 200, 300, 400),
                 end = c(150, 250, 350, 450))

x2 <- data_frame(id2 = 1:4,
                 chromosome = c("chr1", "chr2", "chr2", "chr1"),
                 start = c(140, 210, 400, 300),
                 end = c(160, 240, 415, 320))

# note that the the third and fourth items don't join (even though
# 300-350 and 300-320 overlap) since the chromosomes are different:
genome_inner_join(x1, x2, by = c("chromosome", "start", "end"))

# other functions:
genome_full_join(x1, x2, by = c("chromosome", "start", "end"))
genome_left_join(x1, x2, by = c("chromosome", "start", "end"))
genome_right_join(x1, x2, by = c("chromosome", "start", "end"))
genome_semi_join(x1, x2, by = c("chromosome", "start", "end"))
genome_anti_join(x1, x2, by = c("chromosome", "start", "end"))

}
