% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_similarity_matrix.R
\name{get_similarity_matrix}
\alias{get_similarity_matrix}
\title{Create matrix of embedding similarities}
\usage{
get_similarity_matrix(embeddings, strings_A = NULL, strings_B = NULL)
}
\arguments{
\item{embeddings}{A matrix of text embeddings}

\item{strings_A}{A string vector}

\item{strings_B}{A string vector}
}
\value{
A matrix of cosine similarities between the embeddings of strings_A and the embeddings of strings_B
}
\description{
Create a matrix of pairwise similarities between each string in \code{strings_A} and \code{strings_B}.
}
\examples{

\dontrun{
embeddings <- get_embeddings(c('UPS', 'USPS', 'Postal Service'))
get_similarity_matrix(embeddings)
get_similarity_matrix(embeddings, 'Postal Service')
get_similarity_matrix(embeddings, 'Postal Service', c('UPS', 'USPS'))
}
}
