% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tidy.boottest}
\alias{tidy.boottest}
\title{S3 method to summarize objects of class boottest into tidy data.frame}
\usage{
\method{tidy}{boottest}(x, ...)
}
\arguments{
\item{x}{object of type boottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A tidy data.frame with estimation results for objects of type
boottest
}
\description{
S3 method to summarize objects of class boottest into tidy data.frame
}
\examples{
requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
generics::tidy(boot)
}
