% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_function.R
\name{ml_gKRLS}
\alias{ml_gKRLS}
\alias{SL.mgcv}
\alias{predict.SL.mgcv}
\alias{add_bam_to_mlr3}
\title{Machine Learning with gKRLS}
\usage{
SL.mgcv(Y, X, newX, formula, family, obsWeights, bam = FALSE, ...)

\method{predict}{SL.mgcv}(object, newdata, allow_missing_levels = TRUE, ...)

add_bam_to_mlr3()
}
\arguments{
\item{Y}{This is not usually directly specified in \code{SL.mgcv}, see the
examples below and documentation in \code{SuperLearner} for more details.}

\item{X}{This is not usually directly specified in \code{SL.mgcv}, see the
examples below and documentation in \code{SuperLearner} for more details.}

\item{newX}{This is not usually directly specified in \code{SL.mgcv}, see the
examples below and documentation in \code{SuperLearner} for more details.}

\item{formula}{A formula used for \code{gam} or \code{bam} from
\code{mgcv}. This must be specified, see the examples.}

\item{family}{This is not usually directly specified in \code{SL.mgcv}, see
the examples below and documentation in \code{SuperLearner} for more
details.}

\item{obsWeights}{This is not usually directly specified in \code{SL.mgcv},
see the examples below and documentation in \code{SuperLearner} for more
details.}

\item{bam}{A logical value for whether \code{mgcv::bam} should be used
instead of \code{mgcv::gam}. Default is \code{FALSE}. For large datasets,
this can dramatically improve estimation time. Wood et al. (2015) and
\code{mgcv} provide details on \code{bam}.}

\item{...}{Additional arguments to \code{mgcv::gam} and \code{mgcv::bam}.}

\item{object}{This is not usually directly specified in \code{SL.mgcv}, see
the examples below and documentation in \code{SuperLearner} for more
details.}

\item{newdata}{This is not usually directly specified in \code{SL.mgcv}, see
the examples below and documentation in \code{SuperLearner} for more
details.}

\item{allow_missing_levels}{A logical variable that indicates whether missing
levels in factors are allowed for prediction. The default is \code{TRUE}.}
}
\value{
All three of the returned functions are usually called for use in
  other functions, i.e. creating objects for use in \code{SuperLearner} or
  adding \code{bam} models to \code{mlr3}.
}
\description{
This provides a number of functions to use \code{gKRLS} (and
  \code{mgcv} more generally) as part of machine learning algorithms.
  Integration into \code{SuperLearner} and \code{DoubleML} (and \code{mlr3})
  is described below.
}
\details{
\bold{Ensembles:} \code{SuperLearner} integration is provided by
  \code{SL.mgcv} and the corresponding predict method. \code{mgcv::bam} can be
  enabled by using \code{bam = TRUE}. A formula \bold{without an outcome}
  must be explicitly provided.

  Please note that it is often useful to load \code{SuperLearner} before
  \code{gKRLS} or \code{mgcv} to avoid functions including \code{gam} and
  \code{s} being masked from other packages.

  \bold{Double Machine Learning}: \code{DoubleML} integration is provided in
  two ways. First, one could load \code{mlr3extralearners} to access
  \code{regr.gam} and \code{classif.gam}.

  Second, this package provides \code{mgcv::bam} integration directly with a
  slight adaption of the \code{mlr3extralearner} implementation (see
  \code{?LearnerClassifBam} for more details). These can be either manually
  added to the list of \code{mlr3} learners by calling
  \code{add_bam_to_mlr3()} or direct usage. Examples are provided below. For
  \code{classif.bam} and \code{regr.bam}, the formula argument is mandatory.
}
\examples{
set.seed(789)
N <- 100
x1 <- rnorm(N)
x2 <- rbinom(N, size = 1, prob = .2)
y <- x1^3 - 0.5 * x2 + rnorm(N, 0, 1)
y <- y * 10
X <- cbind(x1, x2, x1 + x2 * 3)
X <- cbind(X, "x3" = rexp(nrow(X)))

if (requireNamespace("SuperLearner", quietly = TRUE)) {
# Estimate Ensemble with SuperLearner
  require(SuperLearner)
  sl_m <- function(...) { SL.mgcv(formula = ~ x1 + x2 + x3, ...) }
  fit_SL <- SuperLearner::SuperLearner(
    Y = y, X = data.frame(X),
    SL.library = "sl_m"
  )
  pred <- predict(fit_SL, newdata = data.frame(X))
}
# Estimate Double/Debiased Machine Learning
if (requireNamespace("DoubleML", quietly = TRUE)) {
  require(DoubleML)
  # Load the models; for testing *ONLY* have multiplier of 2
  double_bam_1 <- LearnerRegrBam$new()
  double_bam_1$param_set$values$formula <- ~ s(x1, x3, bs = "gKRLS", 
    xt = gKRLS(sketch_multiplier = NULL, sketch_size_raw = 2))
  double_bam_2 <- LearnerClassifBam$new()
  double_bam_2$param_set$values$formula <- ~ s(x1, x3, bs = "gKRLS", 
    xt = gKRLS(sketch_multiplier = NULL, sketch_size_raw = 2))

  # Create data
  dml_data <- DoubleMLData$new(
    data = data.frame(X, y),
    x_cols = c("x1", "x3"), y_col = "y",
    d_cols = "x2"
  )
  # Estimate effects treatment (works for other DoubleML methods)
  dml_est <- DoubleMLIRM$new(
    data = dml_data,
    n_folds = 2,
    ml_g = double_bam_1,
    ml_m = double_bam_2
  )$fit()
}
}
\references{
Wood, Simon N and Goude, Yannig and Simon Shaw. 2015. "Generalized Additive
Models for Large Data Sets." \emph{Journal of the Royal Statistical Society:
Series C (Applied Statistics)} 64(1):139-155.
}
