/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.VerticalBox;

public class TeXIcon
implements Icon {
    public static float defaultSize = -1.0f;
    public static float magFactor = 0.0f;
    private Box box;
    private final float size;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Color fg = new Color(0, 0, 0);
    public boolean isColored = false;

    protected TeXIcon(Box b, float size) {
        this(b, size, false);
    }

    protected TeXIcon(Box b, float size, boolean trueValues) {
        this.box = b;
        if (defaultSize != -1.0f) {
            size = defaultSize;
        }
        this.size = magFactor != 0.0f ? size * Math.abs(magFactor) : size;
        if (!trueValues) {
            this.insets.top += (int)(0.18f * size);
            this.insets.bottom += (int)(0.18f * size);
        }
    }

    public void setForeground(Color fg) {
        this.fg = fg != null ? fg : new Color(0, 0, 0);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets, boolean trueValues) {
        this.insets = insets;
        if (!trueValues) {
            this.insets.top += (int)(0.18f * this.size);
            this.insets.bottom += (int)(0.18f * this.size);
        }
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets, false);
    }

    public void setIconWidth(int width, int alignment) {
        float diff = width - this.getIconWidth();
        if (diff > 0.0f) {
            this.box = new HorizontalBox(this.box, this.box.getWidth() + diff, alignment);
        }
    }

    public void setIconHeight(int height, int alignment) {
        float diff = height - this.getIconHeight();
        if (diff > 0.0f) {
            this.box = new VerticalBox(this.box, diff, alignment);
        }
    }

    public int getIconHeight() {
        return (int)((double)(this.box.getHeight() * this.size) + 0.99 + (double)this.insets.top) + (int)((double)(this.box.getDepth() * this.size) + 0.99 + (double)this.insets.bottom);
    }

    public int getIconDepth() {
        return (int)((double)(this.box.getDepth() * this.size) + 0.99 + (double)this.insets.bottom);
    }

    public int getIconWidth() {
        return (int)((double)(this.box.getWidth() * this.size) + 0.99 + (double)this.insets.left + (double)this.insets.right);
    }

    public float getTrueIconHeight() {
        return (this.box.getHeight() + this.box.getDepth()) * this.size;
    }

    public float getTrueIconDepth() {
        return this.box.getDepth() * this.size;
    }

    public float getTrueIconWidth() {
        return this.box.getWidth() * this.size;
    }

    public float getBaseLine() {
        return (float)(((double)(this.box.getHeight() * this.size) + 0.99 + (double)this.insets.top) / ((double)((this.box.getHeight() + this.box.getDepth()) * this.size) + 0.99 + (double)this.insets.top + (double)this.insets.bottom));
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints oldHints = g2.getRenderingHints();
        AffineTransform oldAt = g2.getTransform();
        Color oldColor = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.scale(this.size, this.size);
        g2.setColor(c != null ? c.getForeground() : this.fg);
        this.box.draw(g2, (float)(x + this.insets.left) / this.size, (float)(y + this.insets.top) / this.size + this.box.getHeight());
        g2.setRenderingHints(oldHints);
        g2.setTransform(oldAt);
        g2.setColor(oldColor);
    }
}

