/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.datatable;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.RowModel;
import org.af.gMCP.gui.graph.EdgeWeight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableModel
extends AbstractTableModel {
    protected RDataFrameRef df;
    private RowModel rowModel = null;
    public boolean diagEditable = false;
    boolean testing = false;
    boolean checkRowSum = true;

    public DataTableModel(RDataFrameRef df) {
        this.df = df;
    }

    @Override
    public int getColumnCount() {
        return this.df.getColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.df.getColName(col);
    }

    @Override
    public int getRowCount() {
        return this.df.getRowCount();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int col) {
        return (rowIndex != col || this.diagEditable) && !this.testing;
    }

    public void setValueAt(EdgeWeight value, int row, int col) {
        this.getDataFrame().setValue(row, col, value);
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    @Override
    public EdgeWeight getValueAt(int row, int col) {
        return this.df.getElement(row, col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return EdgeWeight.class;
    }

    public void addRowCol(String name) {
        this.df.addRowCol(name);
        this.fireTableRowsInserted(this.df.getColumnCount(), this.df.getColumnCount());
        this.fireTableStructureChanged();
    }

    public void delRowCol(int col) {
        this.df.delRowCol(col);
        this.fireTableStructureChanged();
    }

    public RDataFrameRef getDataFrame() {
        return this.df;
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        if (this.rowModel != null) {
            this.rowModel.fireTableStructureChanged();
        }
    }

    public void setRowModel(RowModel rowModel) {
        this.rowModel = rowModel;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public void removeAll() {
        this.df.removeAll();
    }

    public boolean checkRowSum() {
        return this.checkRowSum;
    }

    public void setCheckRowSum(boolean checkRowSum) {
        this.checkRowSum = checkRowSum;
    }

    public void copy(DataTableModel model) {
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                this.getDataFrame().setValue(i, j, model.getValueAt(i, j));
            }
        }
        this.fireTableDataChanged();
    }
}

