/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.af.gMCP.gui.MenuBarMGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterDialog
extends JDialog
implements ActionListener,
ChangeListener {
    MenuBarMGraph mbar;
    String command;
    JButton ok = new JButton("Ok");
    JSpinner spinnerN;
    JSpinner spinnerNDoses;
    JSpinner spinnerNTimes;
    JTextField jtW;
    JPanel weightsPanel;
    Hashtable<String, Object> parameters;
    List<JTextField> weightsV = new Vector<JTextField>();

    public ParameterDialog(JFrame parent, Hashtable<String, Object> parameters, MenuBarMGraph menuBarMGraph, String command) {
        super(parent, "Number of Hypotheses", true);
        int[] n;
        this.setLocationRelativeTo(parent);
        this.mbar = menuBarMGraph;
        this.command = command;
        this.parameters = parameters;
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        if (parameters.get("n") != null) {
            rows = rows + ", pref, 5dlu";
        }
        if (parameters.get("weights") != null) {
            rows = rows + ", pref:grow, 5dlu";
        }
        if (parameters.get("times") != null) {
            rows = rows + ", pref, 5dlu";
        }
        if (parameters.get("doses") != null) {
            rows = rows + ", pref, 5dlu";
        }
        if (parameters.get("w") != null) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        if (parameters.get("n") != null) {
            n = (int[])parameters.get("n");
            this.spinnerN = new JSpinner(new SpinnerNumberModel(n[1], n[0], n[2], 1));
            this.spinnerN.addChangeListener(this);
            this.getContentPane().add((Component)new JLabel("Number of hypotheses:"), cc.xy(2, row));
            this.getContentPane().add((Component)this.spinnerN, cc.xy(4, row));
            row += 2;
        }
        if (parameters.get("weights") != null) {
            double[] weights = (double[])parameters.get("weights");
            this.weightsPanel = new JPanel();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.ipadx = 5;
            c.ipady = 5;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.weightsPanel.setLayout(new GridBagLayout());
            int n2 = weights.length == 0 ? Integer.parseInt(this.spinnerN.getModel().getValue().toString()) : weights.length;
            for (int i = 0; i < n2; ++i) {
                this.weightsV.add(new JTextField(weights.length != 0 ? "" + weights[i] : "0"));
                this.weightsPanel.add((Component)new JLabel("H" + (i + 1)), c);
                ++c.gridx;
                this.weightsPanel.add((Component)this.weightsV.get(i), c);
                c.gridx = 0;
                ++c.gridy;
            }
            JScrollPane sp = new JScrollPane(this.weightsPanel);
            this.getContentPane().add((Component)sp, cc.xyw(2, row, 3));
            row += 2;
        }
        if (parameters.get("times") != null) {
            n = (int[])parameters.get("times");
            this.spinnerNTimes = new JSpinner(new SpinnerNumberModel(n[1], n[0], n[2], 1));
            this.spinnerNTimes.addChangeListener(this);
            this.getContentPane().add((Component)new JLabel("Number of time points:"), cc.xy(2, row));
            this.getContentPane().add((Component)this.spinnerNTimes, cc.xy(4, row));
            row += 2;
        }
        if (parameters.get("doses") != null) {
            n = (int[])parameters.get("doses");
            this.spinnerNDoses = new JSpinner(new SpinnerNumberModel(n[1], n[0], n[2], 1));
            this.spinnerNDoses.addChangeListener(this);
            this.getContentPane().add((Component)new JLabel("Number of dose levels:"), cc.xy(2, row));
            this.getContentPane().add((Component)this.spinnerNDoses, cc.xy(4, row));
            row += 2;
        }
        if (parameters.get("w") != null) {
            Double w = (Double)parameters.get("w");
            this.jtW = new JTextField("" + w);
            this.getContentPane().add((Component)new JLabel("Weight:"), cc.xy(2, row));
            this.getContentPane().add((Component)this.jtW, cc.xy(4, row));
            row += 2;
        }
        this.getContentPane().add((Component)this.ok, cc.xy(4, row));
        this.ok.addActionListener(this);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = this.command + "(";
        if (this.parameters.get("n") != null && this.parameters.get("weights") == null) {
            command = command + "n=" + this.spinnerN.getModel().getValue() + ",";
        }
        if (this.parameters.get("weights") != null) {
            command = command + "w=c(";
            for (JTextField tf : this.weightsV) {
                command = command + tf.getText() + ",";
            }
            command = command.substring(0, command.length() - 1) + "),";
        }
        if (this.parameters.get("times") != null) {
            command = command + "times=" + this.spinnerNTimes.getModel().getValue() + ",";
        }
        if (this.parameters.get("doses") != null) {
            command = command + "doses=" + this.spinnerNDoses.getModel().getValue() + ",";
        }
        if (this.parameters.get("w") != null) {
            command = command + "w=" + this.jtW.getText() + ",";
        }
        this.mbar.loadGraph(command.substring(0, command.length() - 1) + ")", false);
        this.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.parameters.get("weights") != null && this.parameters.get("n") != null) {
            int i;
            int n = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
            if (this.weightsV.size() < n) {
                for (i = this.weightsV.size(); i < n; ++i) {
                    this.weightsV.add(new JTextField("0"));
                }
            }
            if (this.weightsV.size() > n) {
                for (i = n; i < this.weightsV.size(); ++i) {
                    this.weightsV.remove(i);
                }
            }
            this.weightsPanel.revalidate();
            this.weightsPanel.removeAll();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.ipadx = 5;
            c.ipady = 5;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.weightsPanel.setLayout(new GridBagLayout());
            for (int i2 = 0; i2 < n; ++i2) {
                this.weightsPanel.add((Component)new JLabel("H" + (i2 + 1)), c);
                ++c.gridx;
                this.weightsPanel.add((Component)this.weightsV.get(i2), c);
                c.gridx = 0;
                ++c.gridy;
            }
            this.weightsPanel.revalidate();
        }
    }
}

