## ------------------------------------------------------------------------
Gm <- matrix(0,nr=4,nc=4)
Gm[1,3] <- 1
Gm[2,4] <- 1
Gm[3,2] <- 1
Gm[4,1] <- 1
Gm

## ------------------------------------------------------------------------
w <- c(1/2,1/2,0,0)
w

## ------------------------------------------------------------------------
Cm <- matrix(NA,nr=4,nc=4)
diag(Cm) <- 1
Cm1 <- Cm
Cm[1,2] <- 1/2
Cm[2,1] <- 1/2
Cm[3,4] <- 1/2
Cm[4,3] <- 1/2
Cm2 <- Cm
Cm1
Cm2

## ----eval=F--------------------------------------------------------------
#  library(gMCP)
#  graphGUI()
#  

## ----eval=F--------------------------------------------------------------
#  Gm <- graph2matrix(createdGraph)
#  w <- getWeights(createdGraph)

## ----eval=F--------------------------------------------------------------
#  G <- matrix2graph(Gm,weights=w)
#  graphGUI(G)

## ------------------------------------------------------------------------
library(gMCP, quietly=TRUE)
generateWeights(Gm,w)

## ------------------------------------------------------------------------
generateBounds(Gm,w,Cm1,al=.025)
generateBounds(Gm,w,Cm2,al=.025)

## ------------------------------------------------------------------------
(1-pnorm(generateBounds(Gm,w,Cm2,al=.025)))*100

## ------------------------------------------------------------------------
Example1 <- generateTest(Gm,w,Cm1,al=.025)
Example2 <- generateTest(Gm,w,Cm2,al=.025)

## ------------------------------------------------------------------------
Example1(c(2.24,2.24,2.24,2.3))
Example2(c(2.24,2.24,2.24,2.3))

## ------------------------------------------------------------------------
p <- 1-pnorm(c(2.24,2.24,2.24,2.3))
G <- matrix2graph(Gm,w)
gMCP(G,p)

## ------------------------------------------------------------------------
gMCP(G,p,corr=Cm2,test="parametric")

