% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hull.R
\name{addRays}
\alias{addRays}
\title{Add all points on the bounding box hit by the rays.}
\usage{
addRays(
  pts,
  m = apply(pts, 2, min) - 5,
  M = apply(pts, 2, max) + 5,
  direction = 1
)
}
\arguments{
\item{pts}{A data frame with all points}

\item{m}{Minimum values of the bounding box.}

\item{M}{Maximum values of the bounding box.}

\item{direction}{Ray direction. If i'th entry is positive, consider the i'th column of the \code{pts}
plus a value greater than on equal zero. If negative, consider the i'th column of the \code{pts}
minus a value greater than on equal zero.}
}
\value{
The points merged with the points on the bounding box. The column \code{pt} equals 1 if
points from pts and zero otherwise.
}
\description{
Add all points on the bounding box hit by the rays.
}
\note{
Assume that \code{pts} has been checked using \link{.checkPts}.
}
\examples{
pts <- genNDSet(3,10)[,1:3]
addRays(pts)
addRays(pts, dir = c(1,-1,1))
addRays(pts, dir = c(-1,-1,1), m = c(0,0,0), M = c(100,100,100))
pts <- genSample(5,20)[,1:5]
addRays(pts)
}
