% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain-simulate.R
\name{grain-simulate}
\alias{grain-simulate}
\alias{simulate.grain}
\title{Simulate from an independence network}
\usage{
\method{simulate}{grain}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{An independence network.}

\item{nsim}{Number of cases to simulate.}

\item{seed}{An optional integer controlling the random number
generatation.}

\item{\dots}{Not used.}
}
\value{
A data frame
}
\description{
Simulate data from an independence network.
}
\examples{

tf <- system.file("huginex", "chest_clinic.net", package = "gRain")

chest <- loadHuginNet(tf, details=1)
simulate(chest,n=10) 

chest2 <- setFinding(chest, c("VisitToAsia", "Dyspnoea"),
                            c("yes", "yes"))
simulate(chest2, n=10)
}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
