\name{breastcancer}
\alias{breastcancer}
\docType{data}
\title{Gene expression signatures for p53
  mutation status in 250 breast cancer samples}

\description{

  Perturbations of the p53 pathway are associated with more aggressive
  and therapeutically refractory tumours. We preprocessed the data using
  Robust Multichip Analysis (RMA). Dataset has been truncated to the 1000 most
  informative genes (as selected by Wilcoxon test statistics) to simplify
  computation. The genes have been standardised to have zero mean and unit
  variance (i.e. z-scored).
}
\usage{data(breastcancer)}
\format{
  A data frame with 250 observations on the following 1001 variables.
  \describe{
    \item{\code{A.1053_at}}{a numeric vector}
    \item{\code{A.200039_s_at}}{a numeric vector}
    \item{\code{A.200053_at}}{a numeric vector}
    \item{\code{A.200079_s_at}}{a numeric vector}
    \item{\code{A.200628_s_at}}{a numeric vector}
    \item{\code{A.200639_s_at}}{a numeric vector}
    \item{\code{A.200670_at}}{a numeric vector}
    \item{\code{A.200687_s_at}}{a numeric vector}
    \item{\code{A.200710_at}}{a numeric vector}
    \item{\code{A.200740_s_at}}{a numeric vector}
    \item{\code{A.200773_x_at}}{a numeric vector}
    \item{\code{A.200783_s_at}}{a numeric vector}
    \item{\code{A.200795_at}}{a numeric vector}
    \item{\code{A.200810_s_at}}{a numeric vector}
    \item{\code{A.200811_at}}{a numeric vector}
    \item{\code{A.200822_x_at}}{a numeric vector}
    \item{\code{A.200840_at}}{a numeric vector}
    \item{\code{A.200853_at}}{a numeric vector}
    \item{\code{A.200854_at}}{a numeric vector}
    \item{\code{A.200855_at}}{a numeric vector}
    \item{\code{A.200996_at}}{a numeric vector}
    \item{\code{A.201041_s_at}}{a numeric vector}
    \item{\code{A.201077_s_at}}{a numeric vector}
    \item{\code{A.201088_at}}{a numeric vector}
    \item{\code{A.201104_x_at}}{a numeric vector}
    \item{\code{A.201114_x_at}}{a numeric vector}
    \item{\code{A.201115_at}}{a numeric vector}
    \item{\code{A.201124_at}}{a numeric vector}
    \item{\code{A.201140_s_at}}{a numeric vector}
    \item{\code{A.201170_s_at}}{a numeric vector}
    \item{\code{A.201195_s_at}}{a numeric vector}
    \item{\code{A.201196_s_at}}{a numeric vector}
    \item{\code{A.201197_at}}{a numeric vector}
    \item{\code{A.201201_at}}{a numeric vector}
    \item{\code{A.201202_at}}{a numeric vector}
    \item{\code{A.201236_s_at}}{a numeric vector}
    \item{\code{A.201263_at}}{a numeric vector}
    \item{\code{A.201266_at}}{a numeric vector}
    \item{\code{A.201281_at}}{a numeric vector}
    \item{\code{A.201291_s_at}}{a numeric vector}
    \item{\code{A.201292_at}}{a numeric vector}
    \item{\code{A.201327_s_at}}{a numeric vector}
    \item{\code{A.201342_at}}{a numeric vector}
    \item{\code{A.201384_s_at}}{a numeric vector}
    \item{\code{A.201394_s_at}}{a numeric vector}
    \item{\code{A.201395_at}}{a numeric vector}
    \item{\code{A.201397_at}}{a numeric vector}
    \item{\code{A.201455_s_at}}{a numeric vector}
    \item{\code{A.201479_at}}{a numeric vector}
    \item{\code{A.201508_at}}{a numeric vector}
    \item{\code{A.201557_at}}{a numeric vector}
    \item{\code{A.201584_s_at}}{a numeric vector}
    \item{\code{A.201591_s_at}}{a numeric vector}
    \item{\code{A.201663_s_at}}{a numeric vector}
    \item{\code{A.201664_at}}{a numeric vector}
    \item{\code{A.201685_s_at}}{a numeric vector}
    \item{\code{A.201694_s_at}}{a numeric vector}
    \item{\code{A.201710_at}}{a numeric vector}
    \item{\code{A.201755_at}}{a numeric vector}
    \item{\code{A.201761_at}}{a numeric vector}
    \item{\code{A.201770_at}}{a numeric vector}
    \item{\code{A.201790_s_at}}{a numeric vector}
    \item{\code{A.201791_s_at}}{a numeric vector}
    \item{\code{A.201795_at}}{a numeric vector}
    \item{\code{A.201833_at}}{a numeric vector}
    \item{\code{A.201890_at}}{a numeric vector}
    \item{\code{A.201896_s_at}}{a numeric vector}
    \item{\code{A.201897_s_at}}{a numeric vector}
    \item{\code{A.201930_at}}{a numeric vector}
    \item{\code{A.201970_s_at}}{a numeric vector}
    \item{\code{A.201977_s_at}}{a numeric vector}
    \item{\code{A.201978_s_at}}{a numeric vector}
    \item{\code{A.202011_at}}{a numeric vector}
    \item{\code{A.202088_at}}{a numeric vector}
    \item{\code{A.202095_s_at}}{a numeric vector}
    \item{\code{A.202105_at}}{a numeric vector}
    \item{\code{A.202107_s_at}}{a numeric vector}
    \item{\code{A.202109_at}}{a numeric vector}
    \item{\code{A.202117_at}}{a numeric vector}
    \item{\code{A.202174_s_at}}{a numeric vector}
    \item{\code{A.202188_at}}{a numeric vector}
    \item{\code{A.202200_s_at}}{a numeric vector}
    \item{\code{A.202233_s_at}}{a numeric vector}
    \item{\code{A.202240_at}}{a numeric vector}
    \item{\code{A.202270_at}}{a numeric vector}
    \item{\code{A.202276_at}}{a numeric vector}
    \item{\code{A.202307_s_at}}{a numeric vector}
    \item{\code{A.202338_at}}{a numeric vector}
    \item{\code{A.202370_s_at}}{a numeric vector}
    \item{\code{A.202371_at}}{a numeric vector}
    \item{\code{A.202409_at}}{a numeric vector}
    \item{\code{A.202487_s_at}}{a numeric vector}
    \item{\code{A.202503_s_at}}{a numeric vector}
    \item{\code{A.202580_x_at}}{a numeric vector}
    \item{\code{A.202589_at}}{a numeric vector}
    \item{\code{A.202590_s_at}}{a numeric vector}
    \item{\code{A.202613_at}}{a numeric vector}
    \item{\code{A.202666_s_at}}{a numeric vector}
    \item{\code{A.202690_s_at}}{a numeric vector}
    \item{\code{A.202705_at}}{a numeric vector}
    \item{\code{A.202725_at}}{a numeric vector}
    \item{\code{A.202754_at}}{a numeric vector}
    \item{\code{A.202779_s_at}}{a numeric vector}
    \item{\code{A.202808_at}}{a numeric vector}
    \item{\code{A.202815_s_at}}{a numeric vector}
    \item{\code{A.202854_at}}{a numeric vector}
    \item{\code{A.202858_at}}{a numeric vector}
    \item{\code{A.202870_s_at}}{a numeric vector}
    \item{\code{A.202954_at}}{a numeric vector}
    \item{\code{A.202962_at}}{a numeric vector}
    \item{\code{A.203022_at}}{a numeric vector}
    \item{\code{A.203046_s_at}}{a numeric vector}
    \item{\code{A.203066_at}}{a numeric vector}
    \item{\code{A.203071_at}}{a numeric vector}
    \item{\code{A.203126_at}}{a numeric vector}
    \item{\code{A.203130_s_at}}{a numeric vector}
    \item{\code{A.203139_at}}{a numeric vector}
    \item{\code{A.203145_at}}{a numeric vector}
    \item{\code{A.203187_at}}{a numeric vector}
    \item{\code{A.203188_at}}{a numeric vector}
    \item{\code{A.203208_s_at}}{a numeric vector}
    \item{\code{A.203213_at}}{a numeric vector}
    \item{\code{A.203214_x_at}}{a numeric vector}
    \item{\code{A.203223_at}}{a numeric vector}
    \item{\code{A.203249_at}}{a numeric vector}
    \item{\code{A.203265_s_at}}{a numeric vector}
    \item{\code{A.203266_s_at}}{a numeric vector}
    \item{\code{A.203276_at}}{a numeric vector}
    \item{\code{A.203287_at}}{a numeric vector}
    \item{\code{A.203296_s_at}}{a numeric vector}
    \item{\code{A.203345_s_at}}{a numeric vector}
    \item{\code{A.203347_s_at}}{a numeric vector}
    \item{\code{A.203358_s_at}}{a numeric vector}
    \item{\code{A.203362_s_at}}{a numeric vector}
    \item{\code{A.203380_x_at}}{a numeric vector}
    \item{\code{A.203405_at}}{a numeric vector}
    \item{\code{A.203418_at}}{a numeric vector}
    \item{\code{A.203422_at}}{a numeric vector}
    \item{\code{A.203428_s_at}}{a numeric vector}
    \item{\code{A.203432_at}}{a numeric vector}
    \item{\code{A.203438_at}}{a numeric vector}
    \item{\code{A.203439_s_at}}{a numeric vector}
    \item{\code{A.203463_s_at}}{a numeric vector}
    \item{\code{A.203484_at}}{a numeric vector}
    \item{\code{A.203554_x_at}}{a numeric vector}
    \item{\code{A.203560_at}}{a numeric vector}
    \item{\code{A.203594_at}}{a numeric vector}
    \item{\code{A.203625_x_at}}{a numeric vector}
    \item{\code{A.203693_s_at}}{a numeric vector}
    \item{\code{A.203696_s_at}}{a numeric vector}
    \item{\code{A.203702_s_at}}{a numeric vector}
    \item{\code{A.203744_at}}{a numeric vector}
    \item{\code{A.203755_at}}{a numeric vector}
    \item{\code{A.203764_at}}{a numeric vector}
    \item{\code{A.203799_at}}{a numeric vector}
    \item{\code{A.203801_at}}{a numeric vector}
    \item{\code{A.203805_s_at}}{a numeric vector}
    \item{\code{A.203806_s_at}}{a numeric vector}
    \item{\code{A.203856_at}}{a numeric vector}
    \item{\code{A.203859_s_at}}{a numeric vector}
    \item{\code{A.203906_at}}{a numeric vector}
    \item{\code{A.203929_s_at}}{a numeric vector}
    \item{\code{A.203930_s_at}}{a numeric vector}
    \item{\code{A.203967_at}}{a numeric vector}
    \item{\code{A.203968_s_at}}{a numeric vector}
    \item{\code{A.204020_at}}{a numeric vector}
    \item{\code{A.204023_at}}{a numeric vector}
    \item{\code{A.204026_s_at}}{a numeric vector}
    \item{\code{A.204033_at}}{a numeric vector}
    \item{\code{A.204045_at}}{a numeric vector}
    \item{\code{A.204072_s_at}}{a numeric vector}
    \item{\code{A.204092_s_at}}{a numeric vector}
    \item{\code{A.204115_at}}{a numeric vector}
    \item{\code{A.204126_s_at}}{a numeric vector}
    \item{\code{A.204127_at}}{a numeric vector}
    \item{\code{A.204146_at}}{a numeric vector}
    \item{\code{A.204162_at}}{a numeric vector}
    \item{\code{A.204170_s_at}}{a numeric vector}
    \item{\code{A.204203_at}}{a numeric vector}
    \item{\code{A.204217_s_at}}{a numeric vector}
    \item{\code{A.204244_s_at}}{a numeric vector}
    \item{\code{A.204267_x_at}}{a numeric vector}
    \item{\code{A.204290_s_at}}{a numeric vector}
    \item{\code{A.204315_s_at}}{a numeric vector}
    \item{\code{A.204317_at}}{a numeric vector}
    \item{\code{A.204318_s_at}}{a numeric vector}
    \item{\code{A.204441_s_at}}{a numeric vector}
    \item{\code{A.204444_at}}{a numeric vector}
    \item{\code{A.204482_at}}{a numeric vector}
    \item{\code{A.204510_at}}{a numeric vector}
    \item{\code{A.204533_at}}{a numeric vector}
    \item{\code{A.204558_at}}{a numeric vector}
    \item{\code{A.204592_at}}{a numeric vector}
    \item{\code{A.204603_at}}{a numeric vector}
    \item{\code{A.204640_s_at}}{a numeric vector}
    \item{\code{A.204641_at}}{a numeric vector}
    \item{\code{A.204649_at}}{a numeric vector}
    \item{\code{A.204675_at}}{a numeric vector}
    \item{\code{A.204686_at}}{a numeric vector}
    \item{\code{A.204695_at}}{a numeric vector}
    \item{\code{A.204702_s_at}}{a numeric vector}
    \item{\code{A.204709_s_at}}{a numeric vector}
    \item{\code{A.204732_s_at}}{a numeric vector}
    \item{\code{A.204766_s_at}}{a numeric vector}
    \item{\code{A.204767_s_at}}{a numeric vector}
    \item{\code{A.204768_s_at}}{a numeric vector}
    \item{\code{A.204800_s_at}}{a numeric vector}
    \item{\code{A.204817_at}}{a numeric vector}
    \item{\code{A.204822_at}}{a numeric vector}
    \item{\code{A.204825_at}}{a numeric vector}
    \item{\code{A.204863_s_at}}{a numeric vector}
    \item{\code{A.204881_s_at}}{a numeric vector}
    \item{\code{A.204962_s_at}}{a numeric vector}
    \item{\code{A.205024_s_at}}{a numeric vector}
    \item{\code{A.205034_at}}{a numeric vector}
    \item{\code{A.205046_at}}{a numeric vector}
    \item{\code{A.205074_at}}{a numeric vector}
    \item{\code{A.205158_at}}{a numeric vector}
    \item{\code{A.205167_s_at}}{a numeric vector}
    \item{\code{A.205186_at}}{a numeric vector}
    \item{\code{A.205214_at}}{a numeric vector}
    \item{\code{A.205225_at}}{a numeric vector}
    \item{\code{A.205240_at}}{a numeric vector}
    \item{\code{A.205279_s_at}}{a numeric vector}
    \item{\code{A.205280_at}}{a numeric vector}
    \item{\code{A.205282_at}}{a numeric vector}
    \item{\code{A.205296_at}}{a numeric vector}
    \item{\code{A.205339_at}}{a numeric vector}
    \item{\code{A.205354_at}}{a numeric vector}
    \item{\code{A.205392_s_at}}{a numeric vector}
    \item{\code{A.205393_s_at}}{a numeric vector}
    \item{\code{A.205394_at}}{a numeric vector}
    \item{\code{A.205436_s_at}}{a numeric vector}
    \item{\code{A.205440_s_at}}{a numeric vector}
    \item{\code{A.205471_s_at}}{a numeric vector}
    \item{\code{A.205472_s_at}}{a numeric vector}
    \item{\code{A.205569_at}}{a numeric vector}
    \item{\code{A.205611_at}}{a numeric vector}
    \item{\code{A.205628_at}}{a numeric vector}
    \item{\code{A.205644_s_at}}{a numeric vector}
    \item{\code{A.205672_at}}{a numeric vector}
    \item{\code{A.205710_at}}{a numeric vector}
    \item{\code{A.205711_x_at}}{a numeric vector}
    \item{\code{A.205733_at}}{a numeric vector}
    \item{\code{A.205776_at}}{a numeric vector}
    \item{\code{A.205779_at}}{a numeric vector}
    \item{\code{A.205794_s_at}}{a numeric vector}
    \item{\code{A.205883_at}}{a numeric vector}
    \item{\code{A.205898_at}}{a numeric vector}
    \item{\code{A.205933_at}}{a numeric vector}
    \item{\code{A.205943_at}}{a numeric vector}
    \item{\code{A.205967_at}}{a numeric vector}
    \item{\code{A.206055_s_at}}{a numeric vector}
    \item{\code{A.206074_s_at}}{a numeric vector}
    \item{\code{A.206091_at}}{a numeric vector}
    \item{\code{A.206102_at}}{a numeric vector}
    \item{\code{A.206134_at}}{a numeric vector}
    \item{\code{A.206197_at}}{a numeric vector}
    \item{\code{A.206245_s_at}}{a numeric vector}
    \item{\code{A.206364_at}}{a numeric vector}
    \item{\code{A.206481_s_at}}{a numeric vector}
    \item{\code{A.206499_s_at}}{a numeric vector}
    \item{\code{A.206600_s_at}}{a numeric vector}
    \item{\code{A.206632_s_at}}{a numeric vector}
    \item{\code{A.206702_at}}{a numeric vector}
    \item{\code{A.206794_at}}{a numeric vector}
    \item{\code{A.206869_at}}{a numeric vector}
    \item{\code{A.207165_at}}{a numeric vector}
    \item{\code{A.207542_s_at}}{a numeric vector}
    \item{\code{A.207783_x_at}}{a numeric vector}
    \item{\code{A.207788_s_at}}{a numeric vector}
    \item{\code{A.207828_s_at}}{a numeric vector}
    \item{\code{A.208029_s_at}}{a numeric vector}
    \item{\code{A.208079_s_at}}{a numeric vector}
    \item{\code{A.208103_s_at}}{a numeric vector}
    \item{\code{A.208140_s_at}}{a numeric vector}
    \item{\code{A.208184_s_at}}{a numeric vector}
    \item{\code{A.208190_s_at}}{a numeric vector}
    \item{\code{A.208308_s_at}}{a numeric vector}
    \item{\code{A.208374_s_at}}{a numeric vector}
    \item{\code{A.208433_s_at}}{a numeric vector}
    \item{\code{A.208503_s_at}}{a numeric vector}
    \item{\code{A.208511_at}}{a numeric vector}
    \item{\code{A.208517_x_at}}{a numeric vector}
    \item{\code{A.208614_s_at}}{a numeric vector}
    \item{\code{A.208627_s_at}}{a numeric vector}
    \item{\code{A.208628_s_at}}{a numeric vector}
    \item{\code{A.208682_s_at}}{a numeric vector}
    \item{\code{A.208691_at}}{a numeric vector}
    \item{\code{A.208693_s_at}}{a numeric vector}
    \item{\code{A.208696_at}}{a numeric vector}
    \item{\code{A.208709_s_at}}{a numeric vector}
    \item{\code{A.208718_at}}{a numeric vector}
    \item{\code{A.208767_s_at}}{a numeric vector}
    \item{\code{A.208794_s_at}}{a numeric vector}
    \item{\code{A.208804_s_at}}{a numeric vector}
    \item{\code{A.208807_s_at}}{a numeric vector}
    \item{\code{A.208870_x_at}}{a numeric vector}
    \item{\code{A.208905_at}}{a numeric vector}
    \item{\code{A.208952_s_at}}{a numeric vector}
    \item{\code{A.208969_at}}{a numeric vector}
    \item{\code{A.209002_s_at}}{a numeric vector}
    \item{\code{A.209019_s_at}}{a numeric vector}
    \item{\code{A.209026_x_at}}{a numeric vector}
    \item{\code{A.209068_at}}{a numeric vector}
    \item{\code{A.209070_s_at}}{a numeric vector}
    \item{\code{A.209071_s_at}}{a numeric vector}
    \item{\code{A.209075_s_at}}{a numeric vector}
    \item{\code{A.209172_s_at}}{a numeric vector}
    \item{\code{A.209189_at}}{a numeric vector}
    \item{\code{A.209195_s_at}}{a numeric vector}
    \item{\code{A.209218_at}}{a numeric vector}
    \item{\code{A.209311_at}}{a numeric vector}
    \item{\code{A.209336_at}}{a numeric vector}
    \item{\code{A.209341_s_at}}{a numeric vector}
    \item{\code{A.209358_at}}{a numeric vector}
    \item{\code{A.209375_at}}{a numeric vector}
    \item{\code{A.209408_at}}{a numeric vector}
    \item{\code{A.209459_s_at}}{a numeric vector}
    \item{\code{A.209460_at}}{a numeric vector}
    \item{\code{A.209464_at}}{a numeric vector}
    \item{\code{A.209482_at}}{a numeric vector}
    \item{\code{A.209523_at}}{a numeric vector}
    \item{\code{A.209603_at}}{a numeric vector}
    \item{\code{A.209604_s_at}}{a numeric vector}
    \item{\code{A.209608_s_at}}{a numeric vector}
    \item{\code{A.209623_at}}{a numeric vector}
    \item{\code{A.209625_at}}{a numeric vector}
    \item{\code{A.209642_at}}{a numeric vector}
    \item{\code{A.209680_s_at}}{a numeric vector}
    \item{\code{A.209709_s_at}}{a numeric vector}
    \item{\code{A.209714_s_at}}{a numeric vector}
    \item{\code{A.209737_at}}{a numeric vector}
    \item{\code{A.209740_s_at}}{a numeric vector}
    \item{\code{A.209747_at}}{a numeric vector}
    \item{\code{A.209753_s_at}}{a numeric vector}
    \item{\code{A.209773_s_at}}{a numeric vector}
    \item{\code{A.209825_s_at}}{a numeric vector}
    \item{\code{A.209832_s_at}}{a numeric vector}
    \item{\code{A.209869_at}}{a numeric vector}
    \item{\code{A.209891_at}}{a numeric vector}
    \item{\code{A.209897_s_at}}{a numeric vector}
    \item{\code{A.210052_s_at}}{a numeric vector}
    \item{\code{A.210092_at}}{a numeric vector}
    \item{\code{A.210093_s_at}}{a numeric vector}
    \item{\code{A.210108_at}}{a numeric vector}
    \item{\code{A.210137_s_at}}{a numeric vector}
    \item{\code{A.210163_at}}{a numeric vector}
    \item{\code{A.210346_s_at}}{a numeric vector}
    \item{\code{A.210365_at}}{a numeric vector}
    \item{\code{A.210416_s_at}}{a numeric vector}
    \item{\code{A.210466_s_at}}{a numeric vector}
    \item{\code{A.210559_s_at}}{a numeric vector}
    \item{\code{A.210567_s_at}}{a numeric vector}
    \item{\code{A.210766_s_at}}{a numeric vector}
    \item{\code{A.210778_s_at}}{a numeric vector}
    \item{\code{A.210821_x_at}}{a numeric vector}
    \item{\code{A.210881_s_at}}{a numeric vector}
    \item{\code{A.211000_s_at}}{a numeric vector}
    \item{\code{A.211034_s_at}}{a numeric vector}
    \item{\code{A.211042_x_at}}{a numeric vector}
    \item{\code{A.211072_x_at}}{a numeric vector}
    \item{\code{A.211080_s_at}}{a numeric vector}
    \item{\code{A.211378_x_at}}{a numeric vector}
    \item{\code{A.211519_s_at}}{a numeric vector}
    \item{\code{A.211714_x_at}}{a numeric vector}
    \item{\code{A.211725_s_at}}{a numeric vector}
    \item{\code{A.211765_x_at}}{a numeric vector}
    \item{\code{A.211939_x_at}}{a numeric vector}
    \item{\code{A.211943_x_at}}{a numeric vector}
    \item{\code{A.211967_at}}{a numeric vector}
    \item{\code{A.211986_at}}{a numeric vector}
    \item{\code{A.212020_s_at}}{a numeric vector}
    \item{\code{A.212022_s_at}}{a numeric vector}
    \item{\code{A.212023_s_at}}{a numeric vector}
    \item{\code{A.212048_s_at}}{a numeric vector}
    \item{\code{A.212151_at}}{a numeric vector}
    \item{\code{A.212195_at}}{a numeric vector}
    \item{\code{A.212196_at}}{a numeric vector}
    \item{\code{A.212209_at}}{a numeric vector}
    \item{\code{A.212219_at}}{a numeric vector}
    \item{\code{A.212228_s_at}}{a numeric vector}
    \item{\code{A.212242_at}}{a numeric vector}
    \item{\code{A.212247_at}}{a numeric vector}
    \item{\code{A.212266_s_at}}{a numeric vector}
    \item{\code{A.212284_x_at}}{a numeric vector}
    \item{\code{A.212296_at}}{a numeric vector}
    \item{\code{A.212299_at}}{a numeric vector}
    \item{\code{A.212319_at}}{a numeric vector}
    \item{\code{A.212419_at}}{a numeric vector}
    \item{\code{A.212423_at}}{a numeric vector}
    \item{\code{A.212430_at}}{a numeric vector}
    \item{\code{A.212448_at}}{a numeric vector}
    \item{\code{A.212492_s_at}}{a numeric vector}
    \item{\code{A.212494_at}}{a numeric vector}
    \item{\code{A.212495_at}}{a numeric vector}
    \item{\code{A.212496_s_at}}{a numeric vector}
    \item{\code{A.212541_at}}{a numeric vector}
    \item{\code{A.212581_x_at}}{a numeric vector}
    \item{\code{A.212660_at}}{a numeric vector}
    \item{\code{A.212680_x_at}}{a numeric vector}
    \item{\code{A.212695_at}}{a numeric vector}
    \item{\code{A.212705_x_at}}{a numeric vector}
    \item{\code{A.212708_at}}{a numeric vector}
    \item{\code{A.212744_at}}{a numeric vector}
    \item{\code{A.212745_s_at}}{a numeric vector}
    \item{\code{A.212779_at}}{a numeric vector}
    \item{\code{A.212815_at}}{a numeric vector}
    \item{\code{A.212846_at}}{a numeric vector}
    \item{\code{A.212865_s_at}}{a numeric vector}
    \item{\code{A.212869_x_at}}{a numeric vector}
    \item{\code{A.212914_at}}{a numeric vector}
    \item{\code{A.212936_at}}{a numeric vector}
    \item{\code{A.212948_at}}{a numeric vector}
    \item{\code{A.212949_at}}{a numeric vector}
    \item{\code{A.212956_at}}{a numeric vector}
    \item{\code{A.212970_at}}{a numeric vector}
    \item{\code{A.212978_at}}{a numeric vector}
    \item{\code{A.212985_at}}{a numeric vector}
    \item{\code{A.213007_at}}{a numeric vector}
    \item{\code{A.213008_at}}{a numeric vector}
    \item{\code{A.213011_s_at}}{a numeric vector}
    \item{\code{A.213018_at}}{a numeric vector}
    \item{\code{A.213058_at}}{a numeric vector}
    \item{\code{A.213063_at}}{a numeric vector}
    \item{\code{A.213088_s_at}}{a numeric vector}
    \item{\code{A.213101_s_at}}{a numeric vector}
    \item{\code{A.213102_at}}{a numeric vector}
    \item{\code{A.213103_at}}{a numeric vector}
    \item{\code{A.213137_s_at}}{a numeric vector}
    \item{\code{A.213175_s_at}}{a numeric vector}
    \item{\code{A.213195_at}}{a numeric vector}
    \item{\code{A.213224_s_at}}{a numeric vector}
    \item{\code{A.213226_at}}{a numeric vector}
    \item{\code{A.213283_s_at}}{a numeric vector}
    \item{\code{A.213285_at}}{a numeric vector}
    \item{\code{A.213366_x_at}}{a numeric vector}
    \item{\code{A.213397_x_at}}{a numeric vector}
    \item{\code{A.213427_at}}{a numeric vector}
    \item{\code{A.213451_x_at}}{a numeric vector}
    \item{\code{A.213453_x_at}}{a numeric vector}
    \item{\code{A.213464_at}}{a numeric vector}
    \item{\code{A.213519_s_at}}{a numeric vector}
    \item{\code{A.213520_at}}{a numeric vector}
    \item{\code{A.213523_at}}{a numeric vector}
    \item{\code{A.213541_s_at}}{a numeric vector}
    \item{\code{A.213571_s_at}}{a numeric vector}
    \item{\code{A.213577_at}}{a numeric vector}
    \item{\code{A.213590_at}}{a numeric vector}
    \item{\code{A.213599_at}}{a numeric vector}
    \item{\code{A.213627_at}}{a numeric vector}
    \item{\code{A.213671_s_at}}{a numeric vector}
    \item{\code{A.213702_x_at}}{a numeric vector}
    \item{\code{A.213720_s_at}}{a numeric vector}
    \item{\code{A.213748_at}}{a numeric vector}
    \item{\code{A.213832_at}}{a numeric vector}
    \item{\code{A.213911_s_at}}{a numeric vector}
    \item{\code{A.213933_at}}{a numeric vector}
    \item{\code{A.214039_s_at}}{a numeric vector}
    \item{\code{A.214053_at}}{a numeric vector}
    \item{\code{A.214061_at}}{a numeric vector}
    \item{\code{A.214062_x_at}}{a numeric vector}
    \item{\code{A.214077_x_at}}{a numeric vector}
    \item{\code{A.214095_at}}{a numeric vector}
    \item{\code{A.214096_s_at}}{a numeric vector}
    \item{\code{A.214101_s_at}}{a numeric vector}
    \item{\code{A.214144_at}}{a numeric vector}
    \item{\code{A.214164_x_at}}{a numeric vector}
    \item{\code{A.214188_at}}{a numeric vector}
    \item{\code{A.214269_at}}{a numeric vector}
    \item{\code{A.214431_at}}{a numeric vector}
    \item{\code{A.214435_x_at}}{a numeric vector}
    \item{\code{A.214437_s_at}}{a numeric vector}
    \item{\code{A.214440_at}}{a numeric vector}
    \item{\code{A.214552_s_at}}{a numeric vector}
    \item{\code{A.214581_x_at}}{a numeric vector}
    \item{\code{A.214657_s_at}}{a numeric vector}
    \item{\code{A.214710_s_at}}{a numeric vector}
    \item{\code{A.214728_x_at}}{a numeric vector}
    \item{\code{A.214745_at}}{a numeric vector}
    \item{\code{A.214919_s_at}}{a numeric vector}
    \item{\code{A.215014_at}}{a numeric vector}
    \item{\code{A.215146_s_at}}{a numeric vector}
    \item{\code{A.215223_s_at}}{a numeric vector}
    \item{\code{A.215300_s_at}}{a numeric vector}
    \item{\code{A.215303_at}}{a numeric vector}
    \item{\code{A.215304_at}}{a numeric vector}
    \item{\code{A.215616_s_at}}{a numeric vector}
    \item{\code{A.215722_s_at}}{a numeric vector}
    \item{\code{A.215867_x_at}}{a numeric vector}
    \item{\code{A.215942_s_at}}{a numeric vector}
    \item{\code{A.216000_at}}{a numeric vector}
    \item{\code{A.216088_s_at}}{a numeric vector}
    \item{\code{A.216109_at}}{a numeric vector}
    \item{\code{A.216237_s_at}}{a numeric vector}
    \item{\code{A.216264_s_at}}{a numeric vector}
    \item{\code{A.216465_at}}{a numeric vector}
    \item{\code{A.216515_x_at}}{a numeric vector}
    \item{\code{A.216520_s_at}}{a numeric vector}
    \item{\code{A.216841_s_at}}{a numeric vector}
    \item{\code{A.216885_s_at}}{a numeric vector}
    \item{\code{A.216952_s_at}}{a numeric vector}
    \item{\code{A.216977_x_at}}{a numeric vector}
    \item{\code{A.217297_s_at}}{a numeric vector}
    \item{\code{A.217346_at}}{a numeric vector}
    \item{\code{A.217398_x_at}}{a numeric vector}
    \item{\code{A.217427_s_at}}{a numeric vector}
    \item{\code{A.217499_x_at}}{a numeric vector}
    \item{\code{A.217714_x_at}}{a numeric vector}
    \item{\code{A.217733_s_at}}{a numeric vector}
    \item{\code{A.217755_at}}{a numeric vector}
    \item{\code{A.217834_s_at}}{a numeric vector}
    \item{\code{A.217838_s_at}}{a numeric vector}
    \item{\code{A.217844_at}}{a numeric vector}
    \item{\code{A.217889_s_at}}{a numeric vector}
    \item{\code{A.217906_at}}{a numeric vector}
    \item{\code{A.217925_s_at}}{a numeric vector}
    \item{\code{A.217938_s_at}}{a numeric vector}
    \item{\code{A.217990_at}}{a numeric vector}
    \item{\code{A.218007_s_at}}{a numeric vector}
    \item{\code{A.218009_s_at}}{a numeric vector}
    \item{\code{A.218039_at}}{a numeric vector}
    \item{\code{A.218065_s_at}}{a numeric vector}
    \item{\code{A.218074_at}}{a numeric vector}
    \item{\code{A.218080_x_at}}{a numeric vector}
    \item{\code{A.218115_at}}{a numeric vector}
    \item{\code{A.218131_s_at}}{a numeric vector}
    \item{\code{A.218146_at}}{a numeric vector}
    \item{\code{A.218193_s_at}}{a numeric vector}
    \item{\code{A.218211_s_at}}{a numeric vector}
    \item{\code{A.218213_s_at}}{a numeric vector}
    \item{\code{A.218219_s_at}}{a numeric vector}
    \item{\code{A.218239_s_at}}{a numeric vector}
    \item{\code{A.218259_at}}{a numeric vector}
    \item{\code{A.218260_at}}{a numeric vector}
    \item{\code{A.218295_s_at}}{a numeric vector}
    \item{\code{A.218308_at}}{a numeric vector}
    \item{\code{A.218349_s_at}}{a numeric vector}
    \item{\code{A.218350_s_at}}{a numeric vector}
    \item{\code{A.218353_at}}{a numeric vector}
    \item{\code{A.218355_at}}{a numeric vector}
    \item{\code{A.218374_s_at}}{a numeric vector}
    \item{\code{A.218384_at}}{a numeric vector}
    \item{\code{A.218418_s_at}}{a numeric vector}
    \item{\code{A.218437_s_at}}{a numeric vector}
    \item{\code{A.218447_at}}{a numeric vector}
    \item{\code{A.218471_s_at}}{a numeric vector}
    \item{\code{A.218474_s_at}}{a numeric vector}
    \item{\code{A.218483_s_at}}{a numeric vector}
    \item{\code{A.218497_s_at}}{a numeric vector}
    \item{\code{A.218499_at}}{a numeric vector}
    \item{\code{A.218512_at}}{a numeric vector}
    \item{\code{A.218538_s_at}}{a numeric vector}
    \item{\code{A.218542_at}}{a numeric vector}
    \item{\code{A.218552_at}}{a numeric vector}
    \item{\code{A.218584_at}}{a numeric vector}
    \item{\code{A.218585_s_at}}{a numeric vector}
    \item{\code{A.218588_s_at}}{a numeric vector}
    \item{\code{A.218662_s_at}}{a numeric vector}
    \item{\code{A.218663_at}}{a numeric vector}
    \item{\code{A.218684_at}}{a numeric vector}
    \item{\code{A.218726_at}}{a numeric vector}
    \item{\code{A.218728_s_at}}{a numeric vector}
    \item{\code{A.218741_at}}{a numeric vector}
    \item{\code{A.218755_at}}{a numeric vector}
    \item{\code{A.218769_s_at}}{a numeric vector}
    \item{\code{A.218795_at}}{a numeric vector}
    \item{\code{A.218834_s_at}}{a numeric vector}
    \item{\code{A.218844_at}}{a numeric vector}
    \item{\code{A.218856_at}}{a numeric vector}
    \item{\code{A.218875_s_at}}{a numeric vector}
    \item{\code{A.218877_s_at}}{a numeric vector}
    \item{\code{A.218883_s_at}}{a numeric vector}
    \item{\code{A.218894_s_at}}{a numeric vector}
    \item{\code{A.218936_s_at}}{a numeric vector}
    \item{\code{A.218966_at}}{a numeric vector}
    \item{\code{A.218976_at}}{a numeric vector}
    \item{\code{A.218982_s_at}}{a numeric vector}
    \item{\code{A.218987_at}}{a numeric vector}
    \item{\code{A.219000_s_at}}{a numeric vector}
    \item{\code{A.219004_s_at}}{a numeric vector}
    \item{\code{A.219010_at}}{a numeric vector}
    \item{\code{A.219031_s_at}}{a numeric vector}
    \item{\code{A.219061_s_at}}{a numeric vector}
    \item{\code{A.219065_s_at}}{a numeric vector}
    \item{\code{A.219091_s_at}}{a numeric vector}
    \item{\code{A.219105_x_at}}{a numeric vector}
    \item{\code{A.219132_at}}{a numeric vector}
    \item{\code{A.219148_at}}{a numeric vector}
    \item{\code{A.219197_s_at}}{a numeric vector}
    \item{\code{A.219252_s_at}}{a numeric vector}
    \item{\code{A.219286_s_at}}{a numeric vector}
    \item{\code{A.219304_s_at}}{a numeric vector}
    \item{\code{A.219306_at}}{a numeric vector}
    \item{\code{A.219396_s_at}}{a numeric vector}
    \item{\code{A.219413_at}}{a numeric vector}
    \item{\code{A.219417_s_at}}{a numeric vector}
    \item{\code{A.219436_s_at}}{a numeric vector}
    \item{\code{A.219440_at}}{a numeric vector}
    \item{\code{A.219455_at}}{a numeric vector}
    \item{\code{A.219463_at}}{a numeric vector}
    \item{\code{A.219469_at}}{a numeric vector}
    \item{\code{A.219490_s_at}}{a numeric vector}
    \item{\code{A.219493_at}}{a numeric vector}
    \item{\code{A.219494_at}}{a numeric vector}
    \item{\code{A.219510_at}}{a numeric vector}
    \item{\code{A.219555_s_at}}{a numeric vector}
    \item{\code{A.219588_s_at}}{a numeric vector}
    \item{\code{A.219646_at}}{a numeric vector}
    \item{\code{A.219650_at}}{a numeric vector}
    \item{\code{A.219686_at}}{a numeric vector}
    \item{\code{A.219687_at}}{a numeric vector}
    \item{\code{A.219689_at}}{a numeric vector}
    \item{\code{A.219713_at}}{a numeric vector}
    \item{\code{A.219787_s_at}}{a numeric vector}
    \item{\code{A.219833_s_at}}{a numeric vector}
    \item{\code{A.219918_s_at}}{a numeric vector}
    \item{\code{A.219922_s_at}}{a numeric vector}
    \item{\code{A.219978_s_at}}{a numeric vector}
    \item{\code{A.219990_at}}{a numeric vector}
    \item{\code{A.220011_at}}{a numeric vector}
    \item{\code{A.220060_s_at}}{a numeric vector}
    \item{\code{A.220094_s_at}}{a numeric vector}
    \item{\code{A.220173_at}}{a numeric vector}
    \item{\code{A.220239_at}}{a numeric vector}
    \item{\code{A.220276_at}}{a numeric vector}
    \item{\code{A.220324_at}}{a numeric vector}
    \item{\code{A.220540_at}}{a numeric vector}
    \item{\code{A.220651_s_at}}{a numeric vector}
    \item{\code{A.220789_s_at}}{a numeric vector}
    \item{\code{A.220865_s_at}}{a numeric vector}
    \item{\code{A.220917_s_at}}{a numeric vector}
    \item{\code{A.221203_s_at}}{a numeric vector}
    \item{\code{A.221207_s_at}}{a numeric vector}
    \item{\code{A.221221_s_at}}{a numeric vector}
    \item{\code{A.221258_s_at}}{a numeric vector}
    \item{\code{A.221272_s_at}}{a numeric vector}
    \item{\code{A.221275_s_at}}{a numeric vector}
    \item{\code{A.221276_s_at}}{a numeric vector}
    \item{\code{A.221436_s_at}}{a numeric vector}
    \item{\code{A.221505_at}}{a numeric vector}
    \item{\code{A.221520_s_at}}{a numeric vector}
    \item{\code{A.221521_s_at}}{a numeric vector}
    \item{\code{A.221562_s_at}}{a numeric vector}
    \item{\code{A.221588_x_at}}{a numeric vector}
    \item{\code{A.221590_s_at}}{a numeric vector}
    \item{\code{A.221676_s_at}}{a numeric vector}
    \item{\code{A.221677_s_at}}{a numeric vector}
    \item{\code{A.221685_s_at}}{a numeric vector}
    \item{\code{A.221740_x_at}}{a numeric vector}
    \item{\code{A.221856_s_at}}{a numeric vector}
    \item{\code{A.221913_at}}{a numeric vector}
    \item{\code{A.221922_at}}{a numeric vector}
    \item{\code{A.221951_at}}{a numeric vector}
    \item{\code{A.222010_at}}{a numeric vector}
    \item{\code{A.222011_s_at}}{a numeric vector}
    \item{\code{A.222039_at}}{a numeric vector}
    \item{\code{A.222043_at}}{a numeric vector}
    \item{\code{A.222077_s_at}}{a numeric vector}
    \item{\code{A.222118_at}}{a numeric vector}
    \item{\code{A.222195_s_at}}{a numeric vector}
    \item{\code{A.36129_at}}{a numeric vector}
    \item{\code{A.37152_at}}{a numeric vector}
    \item{\code{A.38158_at}}{a numeric vector}
    \item{\code{A.39854_r_at}}{a numeric vector}
    \item{\code{A.40016_g_at}}{a numeric vector}
    \item{\code{A.40093_at}}{a numeric vector}
    \item{\code{A.45297_at}}{a numeric vector}
    \item{\code{A.45633_at}}{a numeric vector}
    \item{\code{A.57703_at}}{a numeric vector}
    \item{\code{A.AFFX.HUMGAPDH.M33197_3_at}}{a numeric vector}
    \item{\code{A.AFFX.HUMGAPDH.M33197_M_at}}{a numeric vector}
    \item{\code{B.200039_s_at}}{a numeric vector}
    \item{\code{B.200076_s_at}}{a numeric vector}
    \item{\code{B.200079_s_at}}{a numeric vector}
    \item{\code{B.200086_s_at}}{a numeric vector}
    \item{\code{B.222396_at}}{a numeric vector}
    \item{\code{B.222423_at}}{a numeric vector}
    \item{\code{B.222453_at}}{a numeric vector}
    \item{\code{B.222602_at}}{a numeric vector}
    \item{\code{B.222606_at}}{a numeric vector}
    \item{\code{B.222608_s_at}}{a numeric vector}
    \item{\code{B.222640_at}}{a numeric vector}
    \item{\code{B.222680_s_at}}{a numeric vector}
    \item{\code{B.222740_at}}{a numeric vector}
    \item{\code{B.222752_s_at}}{a numeric vector}
    \item{\code{B.222767_s_at}}{a numeric vector}
    \item{\code{B.222820_at}}{a numeric vector}
    \item{\code{B.222835_at}}{a numeric vector}
    \item{\code{B.222843_at}}{a numeric vector}
    \item{\code{B.222848_at}}{a numeric vector}
    \item{\code{B.222889_at}}{a numeric vector}
    \item{\code{B.222958_s_at}}{a numeric vector}
    \item{\code{B.222962_s_at}}{a numeric vector}
    \item{\code{B.223054_at}}{a numeric vector}
    \item{\code{B.223056_s_at}}{a numeric vector}
    \item{\code{B.223062_s_at}}{a numeric vector}
    \item{\code{B.223068_at}}{a numeric vector}
    \item{\code{B.223096_at}}{a numeric vector}
    \item{\code{B.223100_s_at}}{a numeric vector}
    \item{\code{B.223119_s_at}}{a numeric vector}
    \item{\code{B.223126_s_at}}{a numeric vector}
    \item{\code{B.223186_at}}{a numeric vector}
    \item{\code{B.223204_at}}{a numeric vector}
    \item{\code{B.223225_s_at}}{a numeric vector}
    \item{\code{B.223229_at}}{a numeric vector}
    \item{\code{B.223234_at}}{a numeric vector}
    \item{\code{B.223274_at}}{a numeric vector}
    \item{\code{B.223307_at}}{a numeric vector}
    \item{\code{B.223315_at}}{a numeric vector}
    \item{\code{B.223348_x_at}}{a numeric vector}
    \item{\code{B.223361_at}}{a numeric vector}
    \item{\code{B.223381_at}}{a numeric vector}
    \item{\code{B.223387_at}}{a numeric vector}
    \item{\code{B.223452_s_at}}{a numeric vector}
    \item{\code{B.223480_s_at}}{a numeric vector}
    \item{\code{B.223491_at}}{a numeric vector}
    \item{\code{B.223515_s_at}}{a numeric vector}
    \item{\code{B.223556_at}}{a numeric vector}
    \item{\code{B.223570_at}}{a numeric vector}
    \item{\code{B.223666_at}}{a numeric vector}
    \item{\code{B.223700_at}}{a numeric vector}
    \item{\code{B.223864_at}}{a numeric vector}
    \item{\code{B.224217_s_at}}{a numeric vector}
    \item{\code{B.224320_s_at}}{a numeric vector}
    \item{\code{B.224333_s_at}}{a numeric vector}
    \item{\code{B.224428_s_at}}{a numeric vector}
    \item{\code{B.224468_s_at}}{a numeric vector}
    \item{\code{B.224471_s_at}}{a numeric vector}
    \item{\code{B.224521_s_at}}{a numeric vector}
    \item{\code{B.224523_s_at}}{a numeric vector}
    \item{\code{B.224566_at}}{a numeric vector}
    \item{\code{B.224578_at}}{a numeric vector}
    \item{\code{B.224610_at}}{a numeric vector}
    \item{\code{B.224674_at}}{a numeric vector}
    \item{\code{B.224686_x_at}}{a numeric vector}
    \item{\code{B.224699_s_at}}{a numeric vector}
    \item{\code{B.224752_at}}{a numeric vector}
    \item{\code{B.224753_at}}{a numeric vector}
    \item{\code{B.224903_at}}{a numeric vector}
    \item{\code{B.224944_at}}{a numeric vector}
    \item{\code{B.225004_at}}{a numeric vector}
    \item{\code{B.225064_at}}{a numeric vector}
    \item{\code{B.225071_at}}{a numeric vector}
    \item{\code{B.225083_at}}{a numeric vector}
    \item{\code{B.225092_at}}{a numeric vector}
    \item{\code{B.225099_at}}{a numeric vector}
    \item{\code{B.225100_at}}{a numeric vector}
    \item{\code{B.225142_at}}{a numeric vector}
    \item{\code{B.225162_at}}{a numeric vector}
    \item{\code{B.225191_at}}{a numeric vector}
    \item{\code{B.225268_at}}{a numeric vector}
    \item{\code{B.225291_at}}{a numeric vector}
    \item{\code{B.225300_at}}{a numeric vector}
    \item{\code{B.225309_at}}{a numeric vector}
    \item{\code{B.225327_at}}{a numeric vector}
    \item{\code{B.225365_at}}{a numeric vector}
    \item{\code{B.225379_at}}{a numeric vector}
    \item{\code{B.225402_at}}{a numeric vector}
    \item{\code{B.225454_at}}{a numeric vector}
    \item{\code{B.225468_at}}{a numeric vector}
    \item{\code{B.225501_at}}{a numeric vector}
    \item{\code{B.225592_at}}{a numeric vector}
    \item{\code{B.225611_at}}{a numeric vector}
    \item{\code{B.225613_at}}{a numeric vector}
    \item{\code{B.225629_s_at}}{a numeric vector}
    \item{\code{B.225655_at}}{a numeric vector}
    \item{\code{B.225656_at}}{a numeric vector}
    \item{\code{B.225676_s_at}}{a numeric vector}
    \item{\code{B.225686_at}}{a numeric vector}
    \item{\code{B.225687_at}}{a numeric vector}
    \item{\code{B.225723_at}}{a numeric vector}
    \item{\code{B.225748_at}}{a numeric vector}
    \item{\code{B.225777_at}}{a numeric vector}
    \item{\code{B.225804_at}}{a numeric vector}
    \item{\code{B.225834_at}}{a numeric vector}
    \item{\code{B.225841_at}}{a numeric vector}
    \item{\code{B.225866_at}}{a numeric vector}
    \item{\code{B.226030_at}}{a numeric vector}
    \item{\code{B.226108_at}}{a numeric vector}
    \item{\code{B.226118_at}}{a numeric vector}
    \item{\code{B.226198_at}}{a numeric vector}
    \item{\code{B.226274_at}}{a numeric vector}
    \item{\code{B.226298_at}}{a numeric vector}
    \item{\code{B.226303_at}}{a numeric vector}
    \item{\code{B.226308_at}}{a numeric vector}
    \item{\code{B.226344_at}}{a numeric vector}
    \item{\code{B.226346_at}}{a numeric vector}
    \item{\code{B.226349_at}}{a numeric vector}
    \item{\code{B.226358_at}}{a numeric vector}
    \item{\code{B.226410_at}}{a numeric vector}
    \item{\code{B.226437_at}}{a numeric vector}
    \item{\code{B.226439_s_at}}{a numeric vector}
    \item{\code{B.226456_at}}{a numeric vector}
    \item{\code{B.226466_s_at}}{a numeric vector}
    \item{\code{B.226473_at}}{a numeric vector}
    \item{\code{B.226506_at}}{a numeric vector}
    \item{\code{B.226519_s_at}}{a numeric vector}
    \item{\code{B.226522_at}}{a numeric vector}
    \item{\code{B.226582_at}}{a numeric vector}
    \item{\code{B.226661_at}}{a numeric vector}
    \item{\code{B.226831_at}}{a numeric vector}
    \item{\code{B.226833_at}}{a numeric vector}
    \item{\code{B.226846_at}}{a numeric vector}
    \item{\code{B.226914_at}}{a numeric vector}
    \item{\code{B.226915_s_at}}{a numeric vector}
    \item{\code{B.226936_at}}{a numeric vector}
    \item{\code{B.226974_at}}{a numeric vector}
    \item{\code{B.226977_at}}{a numeric vector}
    \item{\code{B.226980_at}}{a numeric vector}
    \item{\code{B.226992_at}}{a numeric vector}
    \item{\code{B.227021_at}}{a numeric vector}
    \item{\code{B.227047_x_at}}{a numeric vector}
    \item{\code{B.227068_at}}{a numeric vector}
    \item{\code{B.227081_at}}{a numeric vector}
    \item{\code{B.227103_s_at}}{a numeric vector}
    \item{\code{B.227165_at}}{a numeric vector}
    \item{\code{B.227182_at}}{a numeric vector}
    \item{\code{B.227198_at}}{a numeric vector}
    \item{\code{B.227211_at}}{a numeric vector}
    \item{\code{B.227212_s_at}}{a numeric vector}
    \item{\code{B.227227_at}}{a numeric vector}
    \item{\code{B.227232_at}}{a numeric vector}
    \item{\code{B.227279_at}}{a numeric vector}
    \item{\code{B.227350_at}}{a numeric vector}
    \item{\code{B.227363_s_at}}{a numeric vector}
    \item{\code{B.227419_x_at}}{a numeric vector}
    \item{\code{B.227423_at}}{a numeric vector}
    \item{\code{B.227436_at}}{a numeric vector}
    \item{\code{B.227478_at}}{a numeric vector}
    \item{\code{B.227512_at}}{a numeric vector}
    \item{\code{B.227533_at}}{a numeric vector}
    \item{\code{B.227651_at}}{a numeric vector}
    \item{\code{B.227700_x_at}}{a numeric vector}
    \item{\code{B.227703_s_at}}{a numeric vector}
    \item{\code{B.227718_at}}{a numeric vector}
    \item{\code{B.227762_at}}{a numeric vector}
    \item{\code{B.227809_at}}{a numeric vector}
    \item{\code{B.227811_at}}{a numeric vector}
    \item{\code{B.227873_at}}{a numeric vector}
    \item{\code{B.227874_at}}{a numeric vector}
    \item{\code{B.227920_at}}{a numeric vector}
    \item{\code{B.227928_at}}{a numeric vector}
    \item{\code{B.227982_at}}{a numeric vector}
    \item{\code{B.228044_at}}{a numeric vector}
    \item{\code{B.228069_at}}{a numeric vector}
    \item{\code{B.228081_at}}{a numeric vector}
    \item{\code{B.228252_at}}{a numeric vector}
    \item{\code{B.228273_at}}{a numeric vector}
    \item{\code{B.228281_at}}{a numeric vector}
    \item{\code{B.228318_s_at}}{a numeric vector}
    \item{\code{B.228323_at}}{a numeric vector}
    \item{\code{B.228327_x_at}}{a numeric vector}
    \item{\code{B.228361_at}}{a numeric vector}
    \item{\code{B.228468_at}}{a numeric vector}
    \item{\code{B.228469_at}}{a numeric vector}
    \item{\code{B.228476_at}}{a numeric vector}
    \item{\code{B.228504_at}}{a numeric vector}
    \item{\code{B.228505_s_at}}{a numeric vector}
    \item{\code{B.228528_at}}{a numeric vector}
    \item{\code{B.228550_at}}{a numeric vector}
    \item{\code{B.228554_at}}{a numeric vector}
    \item{\code{B.228559_at}}{a numeric vector}
    \item{\code{B.228560_at}}{a numeric vector}
    \item{\code{B.228597_at}}{a numeric vector}
    \item{\code{B.228692_at}}{a numeric vector}
    \item{\code{B.228718_at}}{a numeric vector}
    \item{\code{B.228729_at}}{a numeric vector}
    \item{\code{B.228730_s_at}}{a numeric vector}
    \item{\code{B.228750_at}}{a numeric vector}
    \item{\code{B.228799_at}}{a numeric vector}
    \item{\code{B.228811_at}}{a numeric vector}
    \item{\code{B.228854_at}}{a numeric vector}
    \item{\code{B.228868_x_at}}{a numeric vector}
    \item{\code{B.228915_at}}{a numeric vector}
    \item{\code{B.228931_at}}{a numeric vector}
    \item{\code{B.228955_at}}{a numeric vector}
    \item{\code{B.229030_at}}{a numeric vector}
    \item{\code{B.229062_at}}{a numeric vector}
    \item{\code{B.229097_at}}{a numeric vector}
    \item{\code{B.229127_at}}{a numeric vector}
    \item{\code{B.229150_at}}{a numeric vector}
    \item{\code{B.229169_at}}{a numeric vector}
    \item{\code{B.229170_s_at}}{a numeric vector}
    \item{\code{B.229181_s_at}}{a numeric vector}
    \item{\code{B.229342_at}}{a numeric vector}
    \item{\code{B.229381_at}}{a numeric vector}
    \item{\code{B.229437_at}}{a numeric vector}
    \item{\code{B.229466_at}}{a numeric vector}
    \item{\code{B.229490_s_at}}{a numeric vector}
    \item{\code{B.229538_s_at}}{a numeric vector}
    \item{\code{B.229551_x_at}}{a numeric vector}
    \item{\code{B.229610_at}}{a numeric vector}
    \item{\code{B.229764_at}}{a numeric vector}
    \item{\code{B.229886_at}}{a numeric vector}
    \item{\code{B.230021_at}}{a numeric vector}
    \item{\code{B.230123_at}}{a numeric vector}
    \item{\code{B.230142_s_at}}{a numeric vector}
    \item{\code{B.230165_at}}{a numeric vector}
    \item{\code{B.230250_at}}{a numeric vector}
    \item{\code{B.230451_at}}{a numeric vector}
    \item{\code{B.230469_at}}{a numeric vector}
    \item{\code{B.230863_at}}{a numeric vector}
    \item{\code{B.230966_at}}{a numeric vector}
    \item{\code{B.231002_s_at}}{a numeric vector}
    \item{\code{B.231034_s_at}}{a numeric vector}
    \item{\code{B.231472_at}}{a numeric vector}
    \item{\code{B.231577_s_at}}{a numeric vector}
    \item{\code{B.232065_x_at}}{a numeric vector}
    \item{\code{B.232210_at}}{a numeric vector}
    \item{\code{B.232238_at}}{a numeric vector}
    \item{\code{B.232278_s_at}}{a numeric vector}
    \item{\code{B.232286_at}}{a numeric vector}
    \item{\code{B.232307_at}}{a numeric vector}
    \item{\code{B.232398_at}}{a numeric vector}
    \item{\code{B.232459_at}}{a numeric vector}
    \item{\code{B.232596_at}}{a numeric vector}
    \item{\code{B.232855_at}}{a numeric vector}
    \item{\code{B.232944_at}}{a numeric vector}
    \item{\code{B.232968_at}}{a numeric vector}
    \item{\code{B.233110_s_at}}{a numeric vector}
    \item{\code{B.233388_at}}{a numeric vector}
    \item{\code{B.233413_at}}{a numeric vector}
    \item{\code{B.233520_s_at}}{a numeric vector}
    \item{\code{B.234222_at}}{a numeric vector}
    \item{\code{B.234294_x_at}}{a numeric vector}
    \item{\code{B.234749_s_at}}{a numeric vector}
    \item{\code{B.234863_x_at}}{a numeric vector}
    \item{\code{B.234944_s_at}}{a numeric vector}
    \item{\code{B.234954_at}}{a numeric vector}
    \item{\code{B.234992_x_at}}{a numeric vector}
    \item{\code{B.235040_at}}{a numeric vector}
    \item{\code{B.235046_at}}{a numeric vector}
    \item{\code{B.235117_at}}{a numeric vector}
    \item{\code{B.235124_at}}{a numeric vector}
    \item{\code{B.235181_at}}{a numeric vector}
    \item{\code{B.235193_at}}{a numeric vector}
    \item{\code{B.235363_at}}{a numeric vector}
    \item{\code{B.235369_at}}{a numeric vector}
    \item{\code{B.235425_at}}{a numeric vector}
    \item{\code{B.235542_at}}{a numeric vector}
    \item{\code{B.235545_at}}{a numeric vector}
    \item{\code{B.235547_at}}{a numeric vector}
    \item{\code{B.235570_at}}{a numeric vector}
    \item{\code{B.235572_at}}{a numeric vector}
    \item{\code{B.235609_at}}{a numeric vector}
    \item{\code{B.235662_at}}{a numeric vector}
    \item{\code{B.235709_at}}{a numeric vector}
    \item{\code{B.235771_at}}{a numeric vector}
    \item{\code{B.235786_at}}{a numeric vector}
    \item{\code{B.235789_at}}{a numeric vector}
    \item{\code{B.235800_at}}{a numeric vector}
    \item{\code{B.236050_at}}{a numeric vector}
    \item{\code{B.236064_at}}{a numeric vector}
    \item{\code{B.236312_at}}{a numeric vector}
    \item{\code{B.236641_at}}{a numeric vector}
    \item{\code{B.236787_at}}{a numeric vector}
    \item{\code{B.236953_s_at}}{a numeric vector}
    \item{\code{B.237086_at}}{a numeric vector}
    \item{\code{B.237168_at}}{a numeric vector}
    \item{\code{B.237301_at}}{a numeric vector}
    \item{\code{B.237339_at}}{a numeric vector}
    \item{\code{B.238001_at}}{a numeric vector}
    \item{\code{B.238045_at}}{a numeric vector}
    \item{\code{B.238075_at}}{a numeric vector}
    \item{\code{B.238077_at}}{a numeric vector}
    \item{\code{B.238116_at}}{a numeric vector}
    \item{\code{B.238425_at}}{a numeric vector}
    \item{\code{B.238447_at}}{a numeric vector}
    \item{\code{B.238656_at}}{a numeric vector}
    \item{\code{B.238756_at}}{a numeric vector}
    \item{\code{B.238781_at}}{a numeric vector}
    \item{\code{B.238898_at}}{a numeric vector}
    \item{\code{B.239002_at}}{a numeric vector}
    \item{\code{B.239349_at}}{a numeric vector}
    \item{\code{B.239432_at}}{a numeric vector}
    \item{\code{B.239758_at}}{a numeric vector}
    \item{\code{B.239890_s_at}}{a numeric vector}
    \item{\code{B.240099_at}}{a numeric vector}
    \item{\code{B.240422_at}}{a numeric vector}
    \item{\code{B.241310_at}}{a numeric vector}
    \item{\code{B.241408_at}}{a numeric vector}
    \item{\code{B.241577_at}}{a numeric vector}
    \item{\code{B.241789_at}}{a numeric vector}
    \item{\code{B.241937_s_at}}{a numeric vector}
    \item{\code{B.242218_at}}{a numeric vector}
    \item{\code{B.242255_at}}{a numeric vector}
    \item{\code{B.242323_at}}{a numeric vector}
    \item{\code{B.242560_at}}{a numeric vector}
    \item{\code{B.242657_at}}{a numeric vector}
    \item{\code{B.242890_at}}{a numeric vector}
    \item{\code{B.243754_at}}{a numeric vector}
    \item{\code{B.243806_at}}{a numeric vector}
    \item{\code{B.244116_at}}{a numeric vector}
    \item{\code{B.244375_at}}{a numeric vector}
    \item{\code{B.244571_s_at}}{a numeric vector}
    \item{\code{B.244677_at}}{a numeric vector}
    \item{\code{B.244696_at}}{a numeric vector}
    \item{\code{B.AFFX.HUMGAPDH.M33197_3_at}}{a numeric vector}
    \item{\code{B.AFFX.HUMGAPDH.M33197_M_at}}{a numeric vector}
    \item{\code{code}}{a factor with levels \code{case} \code{control}}
  }
}
\details{
  The factor \code{code} defines whether there was a mutation in the
  p53 sequence (code=case) or not (code=control).
}
\source{
  Dr. Chris Holmes, c.holmes {at} stats {dot.} ox . ac .uk
}
\references{
  Miller et al (2005, PubMed ID:16141321)
}
\examples{
data(breastcancer)
## maybe str(breastcancer) ; plot(breastcancer) ...
}
\keyword{datasets}
