% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_arDist.R
\name{array-distribution}
\alias{ar_dist}
\alias{array-distribution}
\alias{tabDist}
\title{Marginalize and condition in multidimensional array.}
\usage{
ar_dist(tab, marg = NULL, cond = NULL, normalize = TRUE)
}
\arguments{
\item{tab}{Multidimensional array with dimnames.}

\item{marg}{A specification of the desired margin; a character vector, a
numeric vector or a right hand sided formula.}

\item{cond}{A specification of what is conditioned on. Can take two forms:
Form one is a a character vector, a numeric vector or a right hand sided
formula. Form two is as a simple slice of the array, which is a list of
the form var1=value1, var2=value2 etc.}

\item{normalize}{Should the result be normalized to sum to 1.}
}
\value{
A multidimensional array.
}
\description{
Marginalize and condition in a multidimensional
array which is assumed to represent a discrete multivariate
distribution.
}
\note{
\code{ar_dist} is a recent addition and its functionality (and name) may
    change. \code{ar_dist} is based on calling \code{ar_marg} and
    \code{ar_slice}.
}
\examples{

hec <- HairEyeColor

is.named.array( hec )
## We need dimnames, and names on the dimnames

## Marginalize:
ar_dist(hec, marg= ~Hair + Eye)
ar_dist(hec, marg= ~Hair:Eye)
ar_dist(hec, marg= c("Hair", "Eye"))
ar_dist(hec, marg= 1:2)

ar_dist(hec, marg= ~Hair + Eye, normalize=FALSE)

## Condition
ar_dist(hec, cond= ~Sex + Hair)
ar_dist(hec, cond= ~Sex:Hair)
ar_dist(hec, cond= c("Sex", "Hair"))
ar_dist(hec, cond= c(3,1))

ar_dist(hec, cond= list(Hair="Black"))
ar_dist(hec, cond= list(Hair=1))

\dontrun{
## This will fail
ar_dist(hec, cond= list(Hair=c("Black", "Brown")))
ar_dist(hec, cond= list(Hair=1:2))
}
## But this will do the trick
a <- ar_slice(hec, slice=list(Hair=c("Black", "Brown")))
ar_dist(a, cond=~Hair)

## Combined
ar_dist(hec, marg=~Hair+Eye, cond=~Sex)
ar_dist(hec, marg=~Hair+Eye, cond="Sex")

ar_dist(hec, marg=~Hair+Eye, cond=list(Sex="Male"))
ar_dist(hec, marg=~Hair+Eye, cond=list(Sex="Male"), normalize=FALSE)

ar_dist(hec, cond=list(Sex="Male"))
ar_dist(hec, cond=list(Sex="Male"), normalize=FALSE)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{ar_new}}, \code{\link{ar_marg}}, \code{\link{ar_slice}} etc.
}
\keyword{utilities}

