% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility4.R
\name{get-slot}
\alias{get-slot}
\alias{getSlot}
\alias{dimension}
\alias{logL}
\alias{dataRep}
\alias{intRep}
\alias{fitInfo}
\alias{getcc}
\alias{getecc}
\alias{getvcc}
\alias{getedges}
\title{Get slots from RCOX model object.}
\usage{
getSlot(object, slot)

dimension(object)

logL(object)

getSlot(object, slot)

dataRep(object, slot = NULL)

intRep(object, slot = NULL)

fitInfo(object, slot = NULL)

getcc(object, type)

getecc(object)

getvcc(object)

getedges(object, complement = FALSE)
}
\arguments{
\item{object}{RCOX model object.}

\item{slot}{slot.}

\item{type}{Type of colour class.}

\item{complement}{If FALSE, the edges of the model is returned. If
TRUE, the edges not in the model is returned.}
}
\description{
Get slots from RCOX model object.
}
\examples{


data(math)
gm  = ~al:an:st
vcc = list(~me+st, ~ve+an, ~al)
ecc = list(~me:ve+me:al, ~ve:al+al:st)

m1 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math)
getecc(m1)

getSlot(m1,"type")
fitInfo(m1)
fitInfo(m1,"K")
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
