% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing_split1join1.R
\name{join-split}
\alias{join-split}
\alias{join1}
\alias{split1}
\title{Joining and splitting of colour classes in RCOX models}
\arguments{
\item{object}{An RCOX model, an object of class RCOX}

\item{scope}{A specification of colour classes which should be
considered for joining/splitting. If NULL, then all colour
classes are considered.}

\item{type}{Either "ecc" for edge colour classes or "vcc" for
vertex colour classes.}

\item{stat}{Either "wald" for a Wald statistic or "dev" for
deviance statistic.}

\item{details}{Control the amount of output}
}
\value{
A list with entries: \item{tab}{A data frame with the test
  results} \item{cc}{A list of colour classes}
}
\description{
Test for joining of two colour classes (of a specific type) by testing if
their corresponding parameters are not significantly different.  Split a
colour class and test how much this changes the fit of the model.
}
\note{
Note that the keyword 'stat' is not available for split1
  because this function expands the current and hence the Wald
  statistic is not available.  Note also that join1 is simply a
  wrapper for comparecc applied to edge colour classes.
}
\examples{

data(math)
g1     <- ~me:ve:al+al:st:an
m1     <- rcox(gm=g1, data=math)
join1(m1)

gm  = ~al:an:st
vcc = list(~me+st, ~ve+an)
ecc = list(~me:ve+me:al, ~ve:al+al:st)
m2 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math, type="rcon")
split1(m2)

}
\seealso{
\code{\link{rcox}}, \code{\link{update}},
  \code{\link{comparecc}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
