eol <- ifelse(gWidgetsWWWIsLocal(), "\\\\n","\\n")
w <- gwindow("gWidgetsWWW")
g <- ggroup(cont = w, horizontal=FALSE)
ghtml("<h1>gWidgetsWWW</h1>", cont = g)
f <- gexpandgroup("About", cont = g)
ghtml(paste(
            "The gWidgets package provides an API to abstract the interface for a",
            "few of the available GUI toolkits avaiilable through R. The",
            "gWidgetsWWW package provides an implementation of the gWidgets",
            "API for use with through the web. Using just R commands, interactive",
            "GUIs can be produced.",
            "<p><br>",
            "The current status of the project is still experimental. The package",
            "does not have much testing as of yet. As of version 0-0.8 Firefox, Safari, IE and Opera",
            "basically work, although some widgers -- gcanvas, gsvg -- are browser dependent.",
            "<p><br>",
            "To create a web GUI a means must be provided to callback to the web",
            "server when the user initiates an action and then the web server",
            "responds with commands to manipulate the",
            "user's page.",
            "<br>",
            "The package now has a local server for development and stand alone use. This is installed",
            "when the package is.",
            "To server web pages to a wider communituy, the",
            "RApache package <A",
            "href=http://biostat.mc.vanderbilt.edu/rapache/>url</A>, which embeds",
            "an R process within the Apache web server, is used so that callbacks",
            "from the browser to the web server can be processed through R. To",
            "return instructions to the page, javascript is used so that the entire",
            "page need not be reloaded, as javascript can manipulate elements on",
            "the page. The javascript code is simplified by using the ext",
            "javascript libraries <A",
            "href=http://www.extjs.com>extjs.com</a>. These are included with",
            "the package",
            "<br><p> To make an interactive GUI in gWidgets can be",
            "as easy as creating the following script:",
            "<br><p><pre>",
            "w <- gwindow('simple GUI with one button', visible=FALSE)", eol,
            "g <- ggroup(cont= w)",eol,
            "b <- gbutton('click me', cont = g, handler = function(h,...) {",eol,
            "  gmessage('hello world', parent = b)",eol,
          "})",eol,
            "visible(w) <- TRUE", eol,
            "</pre>",
            sep=" "),
      cont = f)



f <- gexpandgroup("Examples", cont = g, horizontal=FALSE)
dir <- system.file("Examples",package="gWidgetsWWW")
files <- list.files(path=dir, pattern="R$")

ghtml("Several examples accompany the package:", cont = f)
makeLinks <- function(i,f) {
  g1 <- ggroup(cont = f)
  b <- gbutton("Source", cont = g1, handler = function(h,...) {
    w1 <- gwindow("Source", parent = w)
    g1 <- ggroup(cont = w1, horizontal=FALSE)
    Rfile <- paste(dir,i, sep=.Platform$file.sep)
    ghtml(paste("<pre>",
                paste(readLines(Rfile), collapse="\n"),
                "</pre>", sep=""), cont = g1)
    gseparator(cont = g1)
    gbutton("dismiss", cont = g1, handler = function(h,...) {
      dispose(w1)
    })
    visible(w1) <- TRUE
  })
  url <- paste("http://www.math.csi.cuny.edu/gWidgetsWWW/run/", i, sep="")
  ghtml(paste("&nbsp;<A href=", url," target='_blank'>",i,"</A>", sep=""), cont = g1)
}
for(i in files) makeLinks(i,f)


f <- gexpandgroup("More information", cont = g)
ghtml(paste("The gWidgetsWWW package is installed from CRAN. After installation,",
            "read the package vignette for information on installation",
            "of external packages, javascript libraries",
            "etc.", sep=" "),
      cont = f)

f <- gexpandgroup("Security", cont = g)
ghtml("Security is a big issue with server installs. The use of RApache reduces the risk dramatically. Read the package vignette for more detail.", cont = f)

f <- gexpandgroup("Recent NEWS", cont = g)
newsfile <- system.file("NEWS", package="gWidgetsWWW")
ghtml(paste("<pre>", paste(readLines(newsfile, n=30)[-(1:2)], collapse=eol), eol, "... %< snip >% ...", "</pre>"), cont=f)


gstatusbar("Powered by RApache and gWidgetsWWW", cont = w)
visible(w) <- TRUE

