% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine-types.R
\name{comboize_and_fortify}
\alias{comboize_and_fortify}
\title{prepare fortified output for multipanel plot}
\usage{
comboize_and_fortify(
  mgen,
  miso,
  mhab,
  gen_beta_levels = 1,
  iso_beta_levels = c(1),
  hab_beta_levels = c(1)
)
}
\arguments{
\item{mgen}{genetics posterior raster}

\item{miso}{isotope posterior raster}

\item{mhab}{habitat suitability raster}

\item{gen_beta_levels}{vector of the desired values of gen_beta}

\item{iso_beta_levels}{vector of the desired values of iso_beta}

\item{hab_beta_levels}{vector of the desired values of hab_beta}
}
\description{
This takes Mgen, Miso, and Mhab for a single bird
and, if available, the true breeding location.  Then it
computes the combo-ized raster at all the requested levels
of the exponents, and creates a fortified data frame of the
results suitable for plotting in ggplot
}
\examples{
# run through the example for comboize to get the variables
# mgen, miso, and mhab that we will use.
example(comboize)

# then run that on the first bird to get a data frame
# that you can use with ggplot
ff <- comboize_and_fortify(mgen[[1]], miso[[1]], mhab)

# this can be plotted with ggplot2
\dontrun{
library(ggplot2)
wmap <- get_wrld_simpl()
ggplot(mapping = aes(x=long, y = lat)) +
  coord_fixed(1.3, xlim = c(-170, -50), ylim = c(33, 70)) +
  geom_polygon(data = wmap, aes(group = group), fill = NA, color = "black", size = .05) +
  geom_raster(data = ff, mapping = aes(fill = prob), interpolate = TRUE) +
  scale_fill_gradientn(colours = c("#EBEBEB", rainbow(7)), na.value = NA) +
  theme_bw() +
  facet_wrap( ~ beta_vals, ncol = 2) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
}

}
