% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print_galah_objects}
\alias{print_galah_objects}
\alias{print.data_request}
\alias{print.files_request}
\alias{print.metadata_request}
\alias{print.query}
\alias{print.query_set}
\alias{print.galah_config}
\title{Print galah objects}
\usage{
\method{print}{data_request}(x, ...)

\method{print}{files_request}(x, ...)

\method{print}{metadata_request}(x, ...)

\method{print}{query}(x, ...)

\method{print}{query_set}(x, ...)

\method{print}{galah_config}(x, ...)
}
\arguments{
\item{x}{an object of the appropriate \code{class}}

\item{...}{Arguments to be passed to or from other methods}
}
\value{
Print does not return an object; instead it prints a description
of the object to the console
}
\description{
As of version 2.0, \code{galah} supports several bespoke object types. Classes
\code{data_request}, \code{metadata_request} and \code{files_request} are for starting pipes
to download different types of information. These objects are parsed using
\code{collapse()} into a \code{query_set} object, which contains a set of \code{query}
objects, each describing one API call. These are then enacted using
\code{compute()} and/or \code{collect()}. Finally, \code{galah_config()} creates an object
of class \code{galah_config} which (unsurprisingly) stores configuration
information.
}
\examples{
# The most common way to start a pipe is with `galah_call()`
# later functions update the `data_request` object
galah_call() |> # same as calling `request_data()`
  filter(year >= 2020) |>
  group_by(year) |>
  count()

# Metadata requests are formatted in a similar way
request_metadata() |>
  filter(field == basisOfRecord) |>
  unnest()

# Queries are converted into a `query_set` by `collapse()`
x <- galah_call() |> # same as calling `request_data()`
  filter(year >= 2020) |>
  count() |>
  collapse()
print(x)
  
# Each `query_set` contains one or more `query` objects
x[[3]]
}
