\name{ga.lts}
\alias{ga.lts}

\title{
Genetic algorithm based lts regression estimation
}
\description{
ga.lts is an R function that estimates the LTS estimator using the genetic algorithms and the C-steps. 
C-steps are defined in Rousseeuw and Van Driessen (2006). 
}
\usage{
ga.lts(formula, h = NULL, iters = 2, popsize = 50, lower , upper, csteps=2)
}
\arguments{
  \item{formula}{
Usual linear model formula such as y~x1+x2+...+xn
}
  \item{h}{
Custom integer. Default value is floor(n/2)+floor((p+1)/2) where n is the number of observations and the p is number of parameters in the model.
}
  \item{iters}{
Number of generations of the genetic algorithm. Default value is 2. 
}
  \item{popsize}{
Number of chromosomes in the genetic algorithm. Default is 50.
}
  \item{lower}{
The lower bound for the regression parameters.
}
  \item{upper}{
The upper bound for the regression parameters.
}
  \item{csteps}{
Number of csteps. Default is 2.
}
}
\details{
Rousseeuw and Van Driessen (2006) suggest to try many random p-subsets and calculate c-steps to estimate the LTS coefficients. 
These iterations are independent and some good observations are forgetten in each step. Genetic algorithms can generate new solutions using best chromosomes in the population using a more efficient way. The ga.lts function tries small number of subsets, iterates C-steps on them and performs
some genetic operators such as selecting, crossing-over and mutating.

ga.lts uses real values in the chromosomes rather than bit strings. For this reason, C-steps are defined differently from the original. ga.lts
tries some randomly selected estimates which are the initial values generated by the genetic algorithm, puts them on the model and calculates residuals. The function takes the best p observations and iterates usual C-steps. In the next generation, best chromosomes and their offsprings will be
tried. 
}
\value{
Algorithm returns a list. The returned list contains these elements:
\item{crit}{
The minimum value of the objective function. Objective function is defined as 'minimum of the sum of h squared residuals' which is called LTS regression.
}
\item{coefficients}{
Estimated LTS parameters.
}
}
\references{
Rousseeuw and Van Driessen (2006), "Computing LTS Regression for Large Data Sets", Data Mining and Knowledge Discovery, 12, 29-45
}
\author{
Mehmet Hakan Satman
}


\examples{
#data generating process
n<-300;
x1<-rnorm(n);
x2<-rnorm(n);
x3<-rnorm(n);
x4<-rnorm(n);
x5<-rnorm(n);
x<-cbind(1,x1,x2,x3,x4,x5);
e<-rnorm(n);
p<-dim(x)[2];
betas<-rep(5,p);
y<-(x\%*\%betas)+e;
h<-floor(n/2)+floor((p+1)/2);
#contaminating Y 
y[(h+1):n]<-1000;


#information
cat("Starting algorihm with configuration:\n");
cat("n=",n,"\n");
cat("p=",p,"\n");
cat("Regression parameters=",betas,"\n");
cat("Last ",n-h," observations are outliers\n");
cat("Doing...\n");

#algorithm starts here
lts<-ga.lts(formula=y~x1+x2+x3+x4+x5, lower=-20, upper=20);
cat("Genetic algorithm LTS with csteps\n");

#Extracting results
cat("Objective function: ",lts$crit,"\n");
cat("Coefficients: ",lts$coefficients,"\n");

}
