\name{gama.plot.partitions}
\alias{gama.plot.partitions}
\title{Plots results of a Gama clustering.}
\description{
  This function takes a gama object and plots the partitions found by the algorithm. The partitions will be coloured accordingly the distribution of the clusters.
}
\usage{
gama.plot.partitions(gama.obj = NULL, view = "pca", \dots)
}
\arguments{
  \item{gama.obj}{an object of type 'gama' generated by an appropriate gama call to gama clustering.}
  \item{view}{the representation used to plot the partitions. If 'pca' is used, the function will perform a Principal Component Analysis over the dataset and plot the two main components. If 'total.sum' is used, the function will sum all dimensions for each observation and plot this sum, highlighting its partitions. If omitted, the default value 'pca' will be used.}
  \item{\dots}{other arguments that user may pass to the function.}

}
\references{
Mardia, K. V., J. T. Kent, and J. M. Bibby (1979) Multivariate Analysis, London: Academic Press.
}
\seealso{
  \code{\link{gama}, \link{print.gama}}.
}

\examples{
# loads path.based dataset
library(gama)
data(path.based)

# the gama clustering algorithm call
gamaObj <- gama(path.based, k = 2, generations = 30)
# ** use at least 100 generations for simple datasets and 500 for complex datasets

# a call to gama.plot.partitions function with "Principal Component Analysis" view method
gama.plot.partitions(gamaObj)

# a call to gama.plot.partitions
\dontrun{gama.plot.partitions(gamaObj)}
}
\keyword{file}
