% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/read.R
\docType{methods}
\name{read}
\alias{read}
\alias{read-method}
\alias{read,character-method}
\title{Data Input}
\usage{
read(file, ...)

\S4method{read}{character}(file, extensions = c("cnf", "tka"), ...)
}
\arguments{
\item{file}{A \code{\link{character}} string giving the path of files to be imported.}

\item{...}{Extra parameters to be passed to \code{\link[rxylib:read_xyData]{rxylib::read_xyData()}}.}

\item{extensions}{A \code{\link{character}} vector specifying the possible
file extensions. It must be one or more of "\code{cnf}", "\code{tka}".}
}
\value{
A \linkS4class{GammaSpectra} object if more than one spectrum are imported
at once, else a \linkS4class{GammaSpectrum} object.
}
\description{
Reads a gamma ray spectrum file.
}
\note{
Only supports Canberra CNF and TKA files.
}
\examples{
## Import a Canberra CNF file
cnf_file <- system.file("extdata/LaBr.CNF", package = "gamma")
(cnf_spc <- read(cnf_file))

## Import a TKA file
tka_file <- system.file("extdata/LaBr.TKA", package = "gamma")
(tka_spc <- read(tka_file))

## Import all files in a given directory
spc_dir <- system.file("extdata/BDX_LaBr_1/calibration", package = "gamma")
(spc <- read(spc_dir))
}
\seealso{
\code{\link[rxylib:read_xyData]{rxylib::read_xyData()}}

Other IO: 
\code{\link{summarise}()}
}
\author{
N. Frerebeau
}
\concept{IO}
