% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request-make.R
\name{request_make}
\alias{request_make}
\title{Make a Google API request}
\usage{
request_make(x, ..., user_agent = gargle_user_agent())
}
\arguments{
\item{x}{List. Holds the components for an HTTP request, presumably created
with \code{\link[=request_develop]{request_develop()}} or \code{\link[=request_build]{request_build()}}. Must contain a \code{method} and
\code{url}. If present, \code{body} and \code{token} are used.}

\item{...}{Optional arguments passed through to the HTTP method.}

\item{user_agent}{A user agent string, prepared by \code{\link[httr:user_agent]{httr::user_agent()}}. When
in doubt, a client package should have an internal function that extends
\code{gargle_user_agent()} by prepending its return value with the client
package's name and version.}
}
\value{
Object of class \code{response} from \link{httr}.
}
\description{
Intended primarily for internal use in client packages that provide
high-level wrappers for users. \code{request_make()} does very little: calls an
HTTP method, only adding a user agent. Typically the input is created with
\code{\link[=request_build]{request_build()}} and the output is processed with \code{\link[=response_process]{response_process()}}.
}
\examples{
\dontrun{
req <- gargle::request_build(
  method = "GET",
  path = "path/to/the/resource",
  token = "PRETEND_I_AM_TOKEN"
)
gargle::request_make(req)
}
}
\seealso{
Other requests and responses: \code{\link{request_develop}},
  \code{\link{response_process}}
}
\concept{requests and responses}
