% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semipara.R
\name{ggbr_semipara}
\alias{ggbr_semipara}
\title{Extract semiparametric estimates of the Gegenbauer factors.}
\usage{
ggbr_semipara(
  x,
  k = 1,
  alpha = 0.8,
  method = "gsp",
  min_freq = 0,
  max_freq = 0.5
)
}
\arguments{
\item{x}{(num) This should be a numeric vector representing the process to estimate.}

\item{k}{(int) The number of Gegenbauer frequencies}

\item{alpha}{(num)}

\item{method}{(char) One of "gsp" or "lpr" - lpr is the log-periodogram-regression technique, "gsp" is the Gaussian
semi-parametric technique. "gsp" is the default. Refer Arteche (1998).}

\item{min_freq}{(num) The minimum frequency to search through for peaks - default 0.0.}

\item{max_freq}{(num) The maximum frequency to search through for peaks - default 0.5.}
}
\value{
An object of class "garma_semipara".
}
\description{
For a Gegenbauer process, use semi-parametric methods to estimate the Gegenbauer frequency and fractional differencing.
}
\examples{
data(AirPassengers)
ap <- as.numeric(diff(AirPassengers,12))
sp <- ggbr_semipara(ap)
print(sp)
}
