% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_flagged.R
\name{process_flagged}
\alias{process_flagged}
\title{Locality Cleaning - Find possibly problematic occurrence records}
\usage{
process_flagged(
  df,
  interactive = TRUE,
  latitude = "latitude",
  longitude = "longitude",
  scientific.name = "scientificName"
)
}
\arguments{
\item{df}{Data frame of occurrence records returned from \code{gators_download()}.}

\item{interactive}{Default = TRUE. The interactive option allows for a visual display
of possible problematic points and the ability to manually remove these points.
Setting \code{interactive = FALSE} will automatically remove these points from the data frame.}

\item{latitude}{Default = "latitude". The name of the latitude column in the data frame.}

\item{longitude}{Default = "longitude". The name of the longitude column in the data frame.}

\item{scientific.name}{Default = "scientificName". The name of the scientific name column in the data frame.}
}
\value{
Return cleaned data frame.
}
\description{
The \code{process_flagged()} function allows you to find and map possible problematic points and
manually inspect and remove these points, if desired. When running the function interactively you can
hover over a point to see the record's scientific name, and click on a point to see the record's coordinates.
}
\details{
This function requires packages CoordinateCleaner, leaflet, and magrittr.
This function requires interactive user input.
}
\examples{
\donttest{
cleaned_data <- process_flagged(data, interactive = FALSE)
}

}
