% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gause_wrapper.R
\name{gause_wrapper}
\alias{gause_wrapper}
\title{Automated wrapper for Gause fitting functions}
\usage{
gause_wrapper(
  time,
  species,
  N_starting = NULL,
  r_starting = NULL,
  A_starting = NULL,
  doplot = TRUE,
  keeptimes = FALSE,
  parm_signs = NULL,
  doopt = TRUE,
  ...
)
}
\arguments{
\item{time}{Vector of time steps corresponding to observations in species data.frame.}

\item{species}{A data.frame with one column per species to be fitted.
Note - column names cannot include white spaces or non-standard special characters.}

\item{N_starting}{Optional starting values for initial abundances.}

\item{r_starting}{Optional starting values for species growth rates. If a value is set to zero, it
#forces that parameter to zero in the fitting. Values of NA are ignored. Defaults to NULL (no starting values).}

\item{A_starting}{Optional starting values for species interaction coefficients. If a value is set to zero, it
#forces that parameter to zero in the fitting. Values of NA are ignored. Defaults to NULL (no starting values).}

\item{doplot}{Logical. Should the resulting model be plotted? Defaults to TRUE.}

\item{keeptimes}{Should predictions be given for the points in the "time" vector, or for a list of 100 evenly spaced time points? Defaults to FALSE.}

\item{parm_signs}{Optional variable specifying signs for parameters. Defaults to NULL (automatically selected).}

\item{doopt}{Should optimizer be used (if TRUE), or should the initial linearized estimates by applied (if FALSE)? Defaults to TRUE.}

\item{...}{Optional additional arguments to be passed to ode and optim functions.}
}
\value{
A list with simulated time series (out), paramter estimates (parameter_intervals),
optimizer output (optout), and raw data used for fitting (rawdata).
}
\description{
Automatically runs routine for finding starting values and
optimal parameter values for a Lotka-Volterra interaction system.
Using the default functions, species dynamics follow the form
dni/dt = ni * (ri + aii * ni + sum_j(aij * nj))
where ri are the elements of vector r, and aij are the elements of matrix A.
}
\examples{

#load competition data
data("gause_1934_science_f02_03")

#subset out data from species grown in mixture
mixturedat<-gause_1934_science_f02_03[gause_1934_science_f02_03$Treatment=="Mixture",]

#extract time and species data
time<-mixturedat$Day
species<-data.frame(mixturedat$Volume_Species1, mixturedat$Volume_Species2)
colnames(species)<-c("P_caudatum", "P_aurelia")

#run wrapper
gause_out<-gause_wrapper(time=time, species=species)
}
\concept{Gause}
\concept{Lokta-Volterra}
\concept{interaction}
\concept{optimization}
