% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/froblmmdch.R
\name{frmch}
\alias{frmch}
\title{Robust selection of covariates using Huber's psi-funtion or Hampel's redescending psi-function  based on all subsets}
\usage{
frmch(y,x,cn=1,cnr=c(1,2,4),p0=0.01,q=-1,sg=0,ind=0,sel=T,inr=T,xinr=F,red=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{Constant  for Huber's psi-function}

\item{cnr}{Constants for for Hampel's three part redescending  psi-function}

\item{p0}{The P-value cut-off}

\item{q}{The numer of covariates available}

\item{sg}{The scale parameter}

\item{ind}{The subset for which the results are required}

\item{sel}{Logical, if TRUE remove all subsets of chosen sets}

\item{inr}{Logical if TRUE include intercept}

\item{xinr}{ Logical If TRUE intercept already included}

\item{red}{Logical If true Hampel's three part redescending psi function}
}
\value{
nv  List of subsets with number of covariates and scale.
}
\description{
Calculates all possible subsets and selects those where each included covariate is significant using a robustified version of flmmdch.R 
}
\examples{
data(boston)
a<-frmch(boston[,14],boston[,1:6])
ind<-decode(57,6)
}
