% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{first_peak}
\alias{first_peak}
\title{Find the first local maxima of a numeric vector}
\usage{
first_peak(
  y,
  x = NULL,
  window_width = NULL,
  window_width_n = NULL,
  window_height = NULL,
  return = "index",
  return_endpoints = TRUE,
  ...
)
}
\arguments{
\item{y}{Numeric vector of y values in which to identify local extrema}

\item{x}{Optional numeric vector of corresponding x values}

\item{window_width}{Width of the window (in units of \code{x}) used to
search for local extrema. A narrower width will be more
sensitive to narrow local maxima/minima, while a wider
width will be less sensitive to local maxima/minima.}

\item{window_width_n}{The maximum number of data points a single 
extrema-search step is allowed to take. For example,
when maxima-finding, the function will not pass
a valley consisting of more than \code{window_width_n}
data points.

A smaller \code{window_width_n} will be more sensitive 
to narrow local maxima/minima, while a larger 
\code{window_width_n} will be less sensitive to 
narrow local maxima/minima.

If not provided, defaults to ~0.2*length(y)}

\item{window_height}{The maximum change in \code{y} a single extrema-search
step is allowed to take.  For example, when 
maxima-finding, the function will not pass a
valley deeper than \code{window_height}.

A smaller \code{window_height} will be more sensitive 
to shallow local maxima/minima, while a larger 
\code{window_height} will be less sensitive to 
shallow maxima/minima.}

\item{return}{One of c("index", "x", "y"), determining whether the function
will return the index, x value, or y value associated with the
first maxima in y values}

\item{return_endpoints}{Should the first or last value in \code{y}
be allowed to be returned?}

\item{...}{Other parameters to pass to \code{find_local_extrema}}
}
\value{
If \code{return = "index"}, a vector of indices corresponding 
          to local extrema in the data
          
        If \code{return = "x"}, a vector of x values corresponding
          to local extrema in the data
         
        If \code{return = "y"}, a vector of y values corresponding
          to local extrema in the data
}
\description{
This function has been deprecated in favor of the identical new 
function \code{first_maxima}
}
\details{
This function takes a vector of \code{y} values and returns the index
(by default) of the first local maxima. It serves as a shortcut
for \code{find_local_extrema(return_maxima = TRUE, return_minima = FALSE)[1]}


If none of \code{window_width}, \code{window_width_n}, or 
\code{window_height} are provided, default value of \code{window_width_n}
will be used.

This function is designed to be compatible for use within
 \code{dplyr::group_by} and \code{dplyr::summarize}
}
\seealso{
[first_maxima()]
}
