% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{make_design}
\alias{make_design}
\title{Make design data.frame(s)}
\usage{
make_design(
  nrows = NULL,
  ncols = NULL,
  block_row_names = NULL,
  block_col_names = NULL,
  block_name_header = "block_name",
  output_format = "tidy",
  wellnames_numeric = FALSE,
  wellnames_sep = "",
  wellnames_colname = "Well",
  colnames_first = FALSE,
  lookup_tbl_start = 1,
  pattern_split = "",
  ...
)
}
\arguments{
\item{nrows, ncols}{Number of rows and columns in the plate data}

\item{block_row_names, block_col_names}{Names of the rows, columns
of the plate blockmeasures data}

\item{block_name_header}{The name of the field containing the
\code{block_names}}

\item{output_format}{One of c("blocks", "blocks_pasted", "wide", "tidy")
denoting the format of the resulting data.frame

For easy merging with tidymeasures, leave as default
of 'tidy'. 

For human-readability to confirm design
is correct, choose 'blocks' or 'blocks_pasted'. 

For writing to block-shaped file(s), choose 'blocks' or
'blocks_pasted'.}

\item{wellnames_numeric}{If \code{block_row_names} or \code{block_col_names}
are not specified, then names will be generated
automatically according to \code{wellnames_numeric}.

If \code{wellnames_numeric} is TRUE, rows and columns
will be numbered with "R" and "C" prefixes, respectively.

If \code{wellnames_numeric} is FALSE, rows will be
lettered A through Z, while columns will be numbered}

\item{wellnames_sep}{A string used when concatenating rownames and column
names to create well names, when 
\code{output_format = "wide"} or 
\code{output_format = "tidy"}}

\item{wellnames_colname}{Header for newly-created column containing the
well names, when \code{output_format = "tidy"}}

\item{colnames_first}{When wellnames are created for 
\code{output_format = "wide"} or 
\code{output_format = "tidy"} by \code{paste}-ing the
rownames and column names, should the column names
come first.}

\item{lookup_tbl_start}{Value in the lookup table for the split pattern values
that corresponds to the first value in the vector.

Lookup table by default is 
c(1,2,...,8,9,A,B,...Y,Z,a,b,...,y,z). If,
for example, lookup_tbl_start = "A", then the lookup
table will now be c(A,B,...Y,Z,a,b,...,y,z)}

\item{pattern_split}{character to split pattern elements provided in
\code{...} by, if they're not already a vector}

\item{...}{Each \code{...} argument must be named, and must be a list with 
           five elements:

             1. a vector of the values
             
             2. a vector of the rows the pattern should be applied to
             
             3. a vector of the columns the pattern should be applied to
             
             4. a string or vector denoting the pattern in which the
                values should be filled into the rows and columns specified.
                
                If it's a string, will be split by \code{pattern_split}.
                Pattern will be used as the indices of the values vector.
              
                0's refer to NA. The pattern will be recycled as necessary
                to fill all the wells of the rows and columns specified.
              
             5. a logical for whether this pattern should be filled byrow}
}
\value{
Depends on \code{output_format}:

        If \code{output_format = "blocks"}, a list of \code{data.frame}'s
        where each \code{data.frame} is block-shaped containing the
        information for a single design element
        
        If \code{output_format = "blocks_pasted"}, a single 
        \code{data.frame} containing the \code{paste}-ed information
        for all design elements
        
        If \code{output_format = "wide"}, a wide-shaped \code{data.frame}
        containing all the design elements
        
        If \code{output_format = "tidy"}, a tidy-shaped \code{data.frame}
        containing all the design elements
}
\description{
This is a function to easily input experimental design elements
for later merging with read data
}
\details{
Note that either \code{nrows} or \code{block_row_names} must be provided
and that either \code{ncols} or \code{block_col_names} must be provided
}
\examples{
make_design(nrows = 8, ncols = 12,
            design_element_name = list(c("A", "B", "C"),
                                       2:7,
                                       2:11,
                                       "112301", 
                                       TRUE))
                          
## To be reminded what arguments are needed, use make_designpattern:
make_design(nrows = 8, ncols = 12,
            design_element_name = make_designpattern(
                 values = c("A", "B", "C"),
                 rows = 2:7, 
                 cols = 2:11,
                 pattern = "112301",
                 byrow = TRUE))              

}
