% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_eic.R
\name{plot_eic}
\alias{plot_eic}
\title{Plots the EICs}
\usage{
plot_eic(eic, title = "EIC", dim = 1)
}
\arguments{
\item{eic}{a \emph{data.frame} object. A data frame of the times and
intensity values of the EIC of interest, ideally the output of find_eic().}

\item{title}{a \emph{string} object. Title placed at the top of the plot.
Default title "EIC".}

\item{dim}{a \emph{integer} object. The time dimensions of the plot, either 1
or 2. Default is 1.}
}
\value{
A \emph{ggplot} object. A scatter plot of the overall time index vs
the intensity values at a given mass of interest.
}
\description{
\code{plot_eic} Plots the EICs
}
\details{
This function produces a scatter plot of the overall time index vs
the intensity values at a given mass of interest using
\code{\link[ggplot2]{ggplot}} from ggplot2 package
\insertCite{ggplot2}{gcxgclab}.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file1,mod_t=.5)
eic <- find_eic(frame, MOI=92.1397,tolerance=0.005)
plot_eic(eic,dim=1,title='EIC for MOI 92.1397')
plot_eic(eic,dim=2,title='EIC for MOI 92.1397')

}
\references{
\insertAllCited{}
}
