% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_rasterize.R
\name{gdal_rasterize}
\alias{gdal_rasterize}
\title{gdal_rasterize}
\usage{
gdal_rasterize(
  src_datasource,
  dst_filename,
  b,
  i,
  at,
  burn,
  a,
  threeD,
  add,
  l,
  where,
  sql,
  dialect,
  of,
  a_srs,
  co,
  a_nodata,
  init,
  te,
  tr,
  tap,
  ts,
  ot,
  q,
  output_Raster = FALSE,
  ignore.full_scan = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{src_datasource}{Character. Any OGR supported readable datasource.}

\item{dst_filename}{Character. The GDAL supported output file. Must support update mode access. Before GDAL 1.8.0, gdal_rasterize could not create new output files.}

\item{b}{Numeric. The band(s) to burn values into. Multiple -b arguments may be used to burn into a list of bands. The default is to burn into band 1.}

\item{i}{Logical. Invert rasterization. Burn the fixed burn value, or the burn value associated with the first feature into all parts of the image not inside the provided a polygon.}

\item{at}{Logical. Enables the ALL_TOUCHED rasterization option so that all pixels touched by lines or polygons will be updated not just those one the line render path, or whose center point is within the polygon. Defaults to disabled for normal rendering rules.}

\item{burn}{Numeric. A fixed value to burn into a band for all objects. A vector of burn options can be supplied, one per band being written to.}

\item{a}{Character. Identifies an attribute field on the features to be used for a burn in value. The value will be burned into all output bands.}

\item{threeD}{Logical. (GDAL parameter '3d') Indicates that a burn value should be extracted from the "Z" values of the feature. These values are adjusted by the burn value given by "-burn value" or "-a attribute_name" if provided. As of now, only points and lines are drawn in 3D.}

\item{add}{Logical. Instead of burning a new value, this adds the new value to the existing raster. Suitable for heatmaps for instance.}

\item{l}{Character. Indicates the layer(s) from the datasource that will be used for input features. May be specified multiple times, but at least one layer name or a -sql option must be specified.}

\item{where}{Character. An optional SQL WHERE style query expression to be applied to select features to burn in from the input layer(s).}

\item{sql}{Character. An SQL statement to be evaluated against the datasource to produce a virtual layer of features to be burned in.}

\item{dialect}{Character. (starting with GDAL 2.1) The SQL dialect. In some cases can be used to use (unoptimized) OGR SQL instead of the native SQL of an RDBMS by passing OGRSQL. Starting with GDAL 1.10, the "SQLITE" dialect can also be used with any datasource.}

\item{of}{Character. (GDAL >= 1.8.0) Select the output format. The default is GeoTIFF (GTiff). Use the short format name.}

\item{a_srs}{Character. (GDAL >= 1.8.0) Override the projection for the output file. If not specified, the projection of the input vector file will be used if available. If incompatible projections between input and output files, no attempt will be made to reproject features. The srs_def may be any of the usual GDAL/OGR forms, complete WKT, PROJ.4, EPSG:n or a file containing the WKT.}

\item{co}{Character. (GDAL >= 1.8.0) Passes a creation option ("NAME=VALUE") to the output format driver. Multiple -co options may be listed. See format specific documentation for legal creation options for each format.}

\item{a_nodata}{Numeric. (GDAL >= 1.8.0) Assign a specified nodata value to output bands.}

\item{init}{Numeric. (GDAL >= 1.8.0) Pre-initialize the output image bands with these values. However, it is not marked as the nodata value in the output file. If only one value is given, the same value is used in all the bands.}

\item{te}{Numeric. c(xmin,ymin,xmax,ymax) (GDAL >= 1.8.0) set georeferenced extents. The values must be expressed in georeferenced units. If not specified, the extent of the output file will be the extent of the vector layers.}

\item{tr}{Numeric. c(xres,yres) (GDAL >= 1.8.0) set target resolution. The values must be expressed in georeferenced units. Both must be positive values.}

\item{tap}{Logical. (GDAL >= 1.8.0) (target aligned pixels) align the coordinates of the extent of the output file to the values of the -tr, such that the aligned extent includes the minimum extent.}

\item{ts}{Numeric. c(width,height) (GDAL >= 1.8.0) set output file size in pixels and lines. Note that -ts cannot be used with -tr}

\item{ot}{Character. (GDAL >= 1.8.0) For the output bands to be of the indicated data type. Defaults to Float64}

\item{q}{Logical. (GDAL >= 1.8.0) Suppress progress monitor and other non-error output.}

\item{output_Raster}{Logical. Return output dst_filename as a RasterBrick?}

\item{ignore.full_scan}{Logical. If FALSE, perform a brute-force scan if other installs are not found.  Default is TRUE.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}
}
\value{
NULL or if(output_Raster), a RasterBrick.
}
\description{
R wrapper for gdal_rasterize: burns vector geometries into a raster
}
\details{
This is an R wrapper for the 'gdal_rasterize' function that is part of the 
Geospatial Data Abstraction Library (GDAL).  It follows the parameter naming
conventions of the original function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single character string following,
precisely, the gdalwarp format (\url{http://www.gdal.org/gdal_rasterize.html}), or,
in some cases, can use R vectors to achieve the same end.  

This function assumes the user has a working GDAL on their system.  If the 
"gdalUtils_gdalPath" option has been set (usually by gdal_setInstallation),
the GDAL found in that path will be used.  If nothing is found, gdal_setInstallation
will be executed to attempt to find a working GDAL that has the right drivers 
as specified with the "of" (output format) parameter.

The user can choose to (optionally) return a RasterBrick of the output file (assuming
raster/rgdal supports the particular output format).
}
\examples{
# We'll pre-check to make sure there is a valid GDAL install
# and that raster and rgdal are also installed.
# Note this isn't strictly neccessary, as executing the function will
# force a search for a valid GDAL install.
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(require(raster) && require(rgdal) && valid_install)
{
# Example from the original gdal_rasterize documentation:
# gdal_rasterize -b 1 -b 2 -b 3 -burn 255 -burn 0 
# 	-burn 0 -l tahoe_highrez_training tahoe_highrez_training.shp tempfile.tif
dst_filename_original  <- system.file("external/tahoe_highrez.tif", package="gdalUtils")
# Back up the file, since we are going to burn stuff into it.
dst_filename <- paste(tempfile(),".tif",sep="")
file.copy(dst_filename_original,dst_filename,overwrite=TRUE)
#Before plot:
plotRGB(brick(dst_filename))
src_dataset <- system.file("external/tahoe_highrez_training.shp", package="gdalUtils")
tahoe_burned <- gdal_rasterize(src_dataset,dst_filename,
	b=c(1,2,3),burn=c(0,255,0),l="tahoe_highrez_training",verbose=TRUE,output_Raster=TRUE)
#After plot:
plotRGB(brick(dst_filename))
}
}
\references{
\url{http://www.gdal.org/gdal_rasterize.html}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) (wrapper) and Frank Warmerdam (GDAL lead developer).
}
