% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{apply_pixel.array}
\alias{apply_pixel.array}
\title{Apply a function over pixels in a four-dimensional (band, time, y, x) array}
\usage{
\method{apply_pixel}{array}(x, FUN, ...)
}
\arguments{
\item{x}{four-dimensional input array with dimensions band, time, y, x (in this order)}

\item{FUN}{function that receives a vector of band values in a one-dimensional array}

\item{...}{further arguments passed to FUN}
}
\description{
Apply a function over pixels in a four-dimensional (band, time, y, x) array
}
\details{
FUN is expected to produce a numeric vector (or scalar) where elements are interpreted as new bands in the result.
}
\note{
This is a helper function that uses the same dimension ordering as gdalcubes. It can be used to simplify 
the application of R functions e.g. over time series in a data cube.
}
\examples{
d <- c(4,16,32,32)
x <- array(rnorm(prod(d)), d)
y <- apply_pixel(x, function(v) {
  v[1] + v[2] + v[3] - v[4]
})
dim(y)
}
