% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice_time}
\alias{slice_time}
\title{Extract a single time slice from a data cube}
\usage{
slice_time(cube, datetime = NULL, it = NULL)
}
\arguments{
\item{cube}{source data cube}

\item{datetime}{character; datetime string of the time slice}

\item{it}{integer; index of the time slice (zero-based)}
}
\description{
Create a proxy data cube, which extracts a time slice from a data cube defined by label (datetime string) or integer index.
}
\details{
Either \code{datetime} or \code{it} must be non-NULL. If both arguments are provided, the integer index \code{it} is ignored.
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}
L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M", aggregation = "median")
L8.cube = raster_cube(L8.col, v, mask=image_mask("BQA", bits=4, values=16))
L8.rgb = select_bands(L8.cube, c("B02", "B03", "B04"))
L8.slice = slice_time(L8.rgb, "2018-03")
L8.slice

\donttest{
plot(L8.slice, rgb=3:1, zlim=c(5000,12000))
}

}
