% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_pixel_line}
\alias{get_pixel_line}
\title{Raster pixel/line from geospatial x,y coordinates}
\usage{
get_pixel_line(xy, gt)
}
\arguments{
\item{xy}{Numeric array of geospatial x,y coordinates in the same
spatial reference system as \code{gt}.}

\item{gt}{Numeric vector of length six. The affine geotransform for the
raster.}
}
\value{
Integer array of raster pixel/line.
}
\description{
\code{get_pixel_line()} converts geospatial coordinates to pixel/line (raster
column, row numbers).
The upper left corner pixel is the raster origin (0,0) with column, row
increasing left to right, top to bottom.
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
## id, x, y in NAD83 / UTM zone 12N
pts <- read.csv(pt_file)
print(pts)
raster_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
ds <- new(GDALRaster, raster_file, TRUE)
gt <- ds$getGeoTransform()
get_pixel_line(as.matrix(pts[,-1]), gt)
ds$close()
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster$getGeoTransform()}}, \code{\link[=inv_geotransform]{inv_geotransform()}}
}
