% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_buffer}
\alias{g_buffer}
\title{Compute buffer of a WKT geometry}
\usage{
g_buffer(wkt, dist, quad_segs = 30)
}
\arguments{
\item{wkt}{Character. OGC WKT string for a simple feature 2D geometry.}

\item{dist}{Numeric buffer distance in units of the \code{wkt} geometry.}

\item{quad_segs}{Integer number of segments used to define a 90 degree
curve (quadrant of a circle). Large values result in large numbers of
vertices in the resulting buffer geometry while small numbers reduce the
accuracy of the result.}
}
\value{
Character string for an OGC WKT polygon.
}
\description{
\code{g_buffer()} builds a new geometry containing the buffer region around
the geometry on which it is invoked. The buffer is a polygon containing
the region within the buffer distance of the original geometry.
}
\examples{
g_buffer(wkt = "POINT (0 0)", dist = 10)
}
\seealso{
\code{\link[=bbox_from_wkt]{bbox_from_wkt()}}, \code{\link[=bbox_to_wkt]{bbox_to_wkt()}}
}
