% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spade.R
\name{spade}
\alias{spade}
\title{spatial association detector (SPADE) model}
\usage{
spade(
  formula,
  data,
  wt = NULL,
  discvar = NULL,
  discnum = 3:22,
  discmethod = "quantile",
  cores = 1,
  seed = 123456789,
  permutations = 0,
  ...
)
}
\arguments{
\item{formula}{A formula of spatial association detector (SPADE) model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{wt}{(optional) The spatial weight matrix. When \code{data} is not an \code{sf} object, must provide \code{wt}.}

\item{discvar}{(optional) Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent variables are
used as \code{discvar}.}

\item{discnum}{(optional) Number of multilevel discretization. Default will use \code{3:22}.}

\item{discmethod}{(optional) The discretization methods. Default all use \code{quantile}. Note
that when using different \code{discmethod} for \code{discvar}, please ensure that the lengths of
both are consistent. Noted that \code{robust} will use \code{robust_disc()}; \code{rpart} will use
\code{rpart_disc()}; Others use \code{st_unidisc()}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{seed}{(optional) Random number seed, default is \code{123456789}.}

\item{permutations}{(optional) The number of permutations for the PSD computation. Default is \code{0},
which means no pseudo-p values are calculated.}

\item{...}{(optional) Other arguments passed to \code{st_unidisc()},\code{robust_disc()} or \code{rpart_disc()}.}
}
\value{
A list.
\describe{
\item{\code{factor}}{the result of SPADE model}
}
}
\description{
Function for spatial association detector (SPADE) model.
}
\examples{
data('sim')
sim1 = sf::st_as_sf(sim,coords = c('lo','la'))
g = spade(y ~ ., data = sim1)
g

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
