% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs_geodetecor.R
\name{srs_geodetector}
\alias{srs_geodetector}
\title{spatial rough set-based geographical detector}
\usage{
srs_geodetector(formula, data, wt = NULL, type = "factor", alpha = 0.95)
}
\arguments{
\item{formula}{A formula of spatial rough set-based geographical detector model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{wt}{Spatial adjacency matrix. If \code{data} is a \code{sf} polygon object, the queen
adjacency matrix is used when no \code{wt} object is provided. In other cases, you must
provide a \code{wt} object.}

\item{type}{(optional) The type of geographical detector, which must be one of
\code{factor}(default), \code{interaction} and \code{ecological}.}

\item{alpha}{(optional) Specifies the size of the alpha (confidence level). Default is \code{0.95}.}
}
\value{
A list of tibble with the corresponding result under different detector types.
\describe{
\item{\code{factor}}{the result of spatial rough set-based factor detector}
\item{\code{interaction}}{the result of spatial rough set-based interaction detector}
\item{\code{ecological}}{the result of spatial rough set-based ecological detector}
}
}
\description{
spatial rough set-based geographical detector
}
\examples{
data('srs_table')
data('srs_wt')
srs_geodetector(d ~ a1 + a2 + a3, data = srs_table, wt = srs_wt)
srs_geodetector(d ~ a1 + a2 + a3, data = srs_table,
                wt = srs_wt, type = 'interaction')
srs_geodetector(d ~ a1 + a2 + a3, data = srs_table,
                wt = srs_wt, type = 'ecological')

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
