% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd_spade.R
\name{psmd_spade}
\alias{psmd_spade}
\title{power of spatial and multilevel discretization determinant(PSMD)}
\usage{
psmd_spade(
  yobs,
  xobs,
  wt,
  discnum = 3:8,
  discmethod = "quantile",
  cores = 1,
  seed = 123456789,
  ...
)
}
\arguments{
\item{yobs}{Variable Y}

\item{xobs}{The original continuous covariable X.}

\item{wt}{The spatial weight matrix.}

\item{discnum}{(optional) Number of multilevel discretizations. Default will use \code{3:8}.}

\item{discmethod}{(optional) The discretize methods. Default will use \code{quantile}.
If \code{discmethod} is set to \code{robust}, the function \code{robust_disc()} will be used. Conversely,
if \code{discmethod} is set to \code{rpart}, the \code{rpart_disc()} function will be used. Others use
\code{sdsfun::discretize_vector()}. Currently, only one \code{discmethod} can be used at a time.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, use parallel computation.}

\item{seed}{(optional) Random seed number, default is \code{123456789}.}

\item{...}{(optional) Other arguments passed to \code{sdsfun::discretize_vector()},\code{robust_disc()} or
\code{rpart_disc()}.}
}
\value{
A value of power of spatial and multilevel discretization determinant \code{PSMDQ_s}.
}
\description{
Function for calculate power of spatial and multilevel discretization determinant \code{PSMDQ_s}.
}
\details{
The power of spatial and multilevel discretization determinant formula is
\eqn{PSMDQ_s = MEAN(Q_s)}
}
\examples{
data('sim')
wt = sdsfun::inverse_distance_swm(sf::st_as_sf(sim,coords = c('lo','la')))
psmd_spade(sim$y,sim$xa,wt)

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
